.\" Copyright (c) 1999, 2003 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH delete-pr 8 "August 2003" "GNATS @VERSION@" "GNATS Admininstration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
delete\-pr \- deletes closed PRs
.SH SYNOPSIS
.hy 0
.na
.TP
.B delete\-pr
[
.B \-V 
|
.B \-\-version
]
|
[
.B \-h
|
.B \-\-help
]
|
.br
[
.BI -d \ name
|
.BI --database= name
]
[
.BR \-c\  | \ \-\-closed\  | \ PR
]
.ad b
.hy 1
.SH DESCRIPTION
Deletes the specified
.BR PR ,
or if the \fB\-\-closed\fR option is given, all of the closed PRs in the
database are deleted.
.P
\fBdelete-pr\fR must be run by the GNATS user (by default \fBgnats\fR).
.P
Note that deleting PRs is generally a \fBvery\fR bad idea.  It flies
in the face of the very idea of using a Problem Reporting system and
should only be considered in special situations.  Such a situation
might for instance arise if a mail loop causes mass duplicate
submissions or if you receive spam to the PR submission e-mail
address.
.SH OPTIONS
.TP
.B \-V\fR,\fB \-\-version
Prints the program version to stdout and exits.
.TP
.B \-h\fR,\fB \-\-help
Prints a short help text to stdout and exits.
.TP
.B \-d\fR,\fB \-\-database
Specifies the database from which the PR(s) are to be deleted.  If no
database is specified, the database named \fIdefault\fR is assumed.
This option overrides the database specified in the \fBGNATSDB\fR
environment variable.
.TP
.B \-\-closed
Requests that all closed PRs in the database be deleted.
.TP
.B PR
Requests that the specified \fBPR\fR be deleted.  The \fBPR\fR must be
in a closed state.
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set and the \fB--database\fR option is not
supplied, it is assumed that the database is local and that its name
is
\fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR databases (5),
.BR dbconfig (5),
.BR delete-pr (8),
.BR edit-pr (1)
.BR file-pr (8),
.BR gen-index (8),
.BR gnats (7),
.BR gnatsd (8),
.BR mkcat (8),
.BR mkdb (8),
.BR pr-edit (8),
.BR query-pr (1),
.BR queue-pr (8),
.BR send-pr (1).
.SH COPYING
Copyright (c) 1999, 2003, Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
