// Check whether debug information for system header functions vector::insert and vector::pop_back are generated
// for a test program that includes <vector>.  Debug info for these functions should be generated by default, but
// should not be generated with -fno-system-debug.

// There is nothing special about vector::insert and vector::pop_back versus other system header functions.  They
// are just two representative examples of functions declared in a system header file that can be used to
// exercise -fno-system-debug

// This testcase tests four option settings:
// By default                                                                              debug info for vector::insert and vector::pop_back is generated
// When -fno-system-debug is used                                                          debug info for vector::insert and vector::pop_back is NOT generated
// When -fstandalone-debug is used more debug info is generated and                        debug info for vector::insert and vector::pop_back is generated
// When -fno-eliminate-unused-debug-types is used even more debug info is generated and    debug info for vector::insert and vector::pop_back is generated

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Prepare check results.  Expected mangled names are different between Linux and Windows.
// RUN: %clang %s -DCHECK_RESULTS -E > %t.check_results
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// only vector::insert is in the user source
//
// RUN: %clang -emit-llvm -S -g %s -o  %t.default                                                           -DINSERT
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_system_debug                 -fno-system-debug                 -DINSERT
// RUN: %clang -emit-llvm -S -g %s -o  %t.standalone_debug                -fstandalone-debug                -DINSERT
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_eliminate_unused_debug_types -fno-eliminate-unused-debug-types -DINSERT

// RUN: grep DISubprogram %t.default                         | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_system_debug                 | FileCheck --check-prefix=CHECK-NO-DEBUG  %t.check_results
// RUN: grep DISubprogram %t.standalone_debug                | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_eliminate_unused_debug_types | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// vector::pop_back and vector::insert are both in user source
//
// RUN: %clang -emit-llvm -S -g %s -o  %t.default                                                           -DINSERT -DPOP_BACK
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_system_debug                 -fno-system-debug                 -DINSERT -DPOP_BACK
// RUN: %clang -emit-llvm -S -g %s -o  %t.standalone_debug                -fstandalone-debug                -DINSERT -DPOP_BACK
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_eliminate_unused_debug_types -fno-eliminate-unused-debug-types -DINSERT -DPOP_BACK

// RUN: grep DISubprogram %t.default                         | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_system_debug                 | FileCheck --check-prefix=CHECK-NO-DEBUG  %t.check_results
// RUN: grep DISubprogram %t.standalone_debug                | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_eliminate_unused_debug_types | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// class vector<int> is explicitly instantiated.
// vector::pop_back and vector::insert are NOT in user source
//
// RUN: %clang -emit-llvm -S -g %s -o  %t.default                                                           -DEXPLICIT_INSTANTIATION
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_system_debug                 -fno-system-debug                 -DEXPLICIT_INSTANTIATION
// RUN: %clang -emit-llvm -S -g %s -o  %t.standalone_debug                -fstandalone-debug                -DEXPLICIT_INSTANTIATION
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_eliminate_unused_debug_types -fno-eliminate-unused-debug-types -DEXPLICIT_INSTANTIATION

// RUN: grep DISubprogram %t.default                         | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_system_debug                 | FileCheck --check-prefix=CHECK-NO-DEBUG  %t.check_results
// RUN: grep DISubprogram %t.standalone_debug                | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_eliminate_unused_debug_types | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// class vector<int> is explicitly instantiated.
// vector::pop_back and vector::insert are BOTH in user source
//
// RUN: %clang -emit-llvm -S -g %s -o  %t.default                                                           -DEXPLICIT_INSTANTIATION -DINSERT -DPOP_BACK
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_system_debug                 -fno-system-debug                 -DEXPLICIT_INSTANTIATION -DINSERT -DPOP_BACK
// RUN: %clang -emit-llvm -S -g %s -o  %t.standalone_debug                -fstandalone-debug                -DEXPLICIT_INSTANTIATION -DINSERT -DPOP_BACK
// RUN: %clang -emit-llvm -S -g %s -o  %t.no_eliminate_unused_debug_types -fno-eliminate-unused-debug-types -DEXPLICIT_INSTANTIATION -DINSERT -DPOP_BACK

// RUN: grep DISubprogram %t.default                         | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_system_debug                 | FileCheck --check-prefix=CHECK-NO-DEBUG  %t.check_results
// RUN: grep DISubprogram %t.standalone_debug                | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results
// RUN: grep DISubprogram %t.no_eliminate_unused_debug_types | FileCheck --check-prefix=CHECK-ALL-DEBUG %t.check_results

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef CHECK_RESULTS
#if defined(_WIN32) || defined(_WIN64)
// vector::pop_back and vector::insert must both not be found
; CHECK-NO-DEBUG-NOT:                               ?pop_back@?$vector@HV?$allocator@H@std@@@std@@QEAAXXZ
; CHECK-NO-DEBUG-NOT:                               ?insert@?$vector@HV?$allocator@H@std@@@std@@QEAA?AV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@H@std@@@std@@@2@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@H@std@@@std@@@2@$$QEAH@Z

// vector::pop_back and vector::insert must both be found
; CHECK-ALL-DEBUG:                                  ?pop_back@?$vector@HV?$allocator@H@std@@@std@@QEAAXXZ
; CHECK-ALL-DEBUG:                                  ?insert@?$vector@HV?$allocator@H@std@@@std@@QEAA?AV?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@H@std@@@std@@@2@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@H@std@@@std@@@2@$$QEAH@Z
#else
// vector::pop_back and vector::insert must both not be found
; CHECK-NO-DEBUG-NOT:                               _ZNSt6vectorIiSaIiEE8pop_backEv
; CHECK-NO-DEBUG-NOT:                               _ZNSt6vectorIiSaIiEE6insertEN9__gnu_cxx17__normal_iteratorIPKiS1_EEOi

// vector::pop_back and vector::insert must both be found
; CHECK-ALL-DEBUG:                                  _ZNSt6vectorIiSaIiEE8pop_backEv
; CHECK-ALL-DEBUG:                                  _ZNSt6vectorIiSaIiEE6insertEN9__gnu_cxx17__normal_iteratorIPKiS1_EEOi
#endif
#endif // CHECK_RESULTS

#include <vector>

#ifdef EXPLICIT_INSTANTIATION
template class std::vector<int>;
#endif

int main() {
#if defined(INSERT) || defined(POP_BACK)
  std::vector<int> a;
#endif
  
#ifdef INSERT
  a.insert(a.begin(),2);
#endif
#ifdef POP_BACK  
  a.pop_back();
#endif
}
