/*
 * $Id$
 *
 * SNMPStats Module 
 * Copyright (C) 2006 SOMA Networks, INC.
 * Written by: Jeffrey Magder (jmagder@somanetworks.com)
 *
 * This file is part of Kamailio, a free SIP server.
 *
 * Kamailio is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * Kamailio is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * History:
 * --------
 * 2006-11-23 initial version (jmagder)
 * 2007-02-16 Moved all OID registrations from the experimental branch to 
 *            Kamailio's IANA assigned enterprise branch. (jmagder)
 * 
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.notify.conf,v 5.3 2004/04/15 12:29:19 dts12 Exp $
 *
 * This file contains functions for sending all traps supported by the SNMPStats
 * module.  
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "snmpstats_globals.h"
#include "snmpMIBNotifications.h"
#include "../../dprint.h"
#include "../../config.h"

static oid snmptrap_oid[] = {1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0};

/* 
 * Sends off an kamailioMsgQueueDepthMinorEvent trap to the master agent,
 * assigning the following variable bindings:
 *
 *  - kamailioMsgQueueDepth          = msgQueueDepth
 *  - kamailioMsgQueueMinorThreshold = minorThreshold
 *
 */
int send_kamailioMsgQueueDepthMinorEvent_trap(int msgQueueDepth, 
		int minorThreshold)
{
	netsnmp_variable_list  *var_list = NULL;
	
	oid kamailioMsgQueueDepthMinorEvent_oid[] = { 
		KAMAILIO_OID,3,1,3,2,0,1 };

	oid kamailioMsgQueueDepth_oid[]		 = { 
		KAMAILIO_OID,3,1,3,1,2,3,1,0 };

	oid kamailioMsgQueueMinorThreshold_oid[]  = { 
		KAMAILIO_OID,3,1,3,1,2,3,2,0 };

	snmp_varlist_add_variable(&var_list,
			snmptrap_oid, 
			OID_LENGTH(snmptrap_oid),
			ASN_OBJECT_ID,
			(u_char *)kamailioMsgQueueDepthMinorEvent_oid, 
			(int)sizeof(kamailioMsgQueueDepthMinorEvent_oid));
	
	snmp_varlist_add_variable(&var_list,
			kamailioMsgQueueDepth_oid, 
			OID_LENGTH(kamailioMsgQueueDepth_oid),
			ASN_GAUGE,
			(u_char *)&msgQueueDepth, 
			sizeof(msgQueueDepth));

	snmp_varlist_add_variable(&var_list,
			kamailioMsgQueueMinorThreshold_oid, 
			OID_LENGTH(kamailioMsgQueueMinorThreshold_oid),
			ASN_INTEGER,
			(u_char *)&minorThreshold,
			sizeof(minorThreshold));

	send_v2trap( var_list );
	snmp_free_varbind( var_list );

	return SNMP_ERR_NOERROR;
}

/*
 * Sends off an kamailioMsgQueueDepthMajorEvent trap to the master agent,
 * assigning the following variable bindings:
 *
 *  - kamailioMsgQueueDepth          = msgQueueDepth
 *  - kamailioMsgQueueMajorThreshold = majorThreshold
 *
 */
int send_kamailioMsgQueueDepthMajorEvent_trap(int msgQueueDepth, 
		int majorThreshold)
{
	netsnmp_variable_list  *var_list = NULL;

	oid kamailioMsgQueueDepthMajorEvent_oid[] = { 
		KAMAILIO_OID,3,1,3,2,0,2 };

	oid kamailioMsgQueueDepth_oid[]		 = {
		KAMAILIO_OID,3,1,3,1,2,3,1,0 };

	oid kamailioMsgQueueMajorThreshold_oid[]  = { 
		KAMAILIO_OID,3,1,3,1,2,3,3,0 };

	snmp_varlist_add_variable(&var_list, 
		snmptrap_oid,
		OID_LENGTH(snmptrap_oid), 
		ASN_OBJECT_ID,
		(u_char *)kamailioMsgQueueDepthMajorEvent_oid,
		(int)sizeof(kamailioMsgQueueDepthMajorEvent_oid));
	
	snmp_varlist_add_variable(&var_list, 
			kamailioMsgQueueDepth_oid,
			OID_LENGTH(kamailioMsgQueueDepth_oid),
			ASN_GAUGE,
			(u_char *)&msgQueueDepth, 
			sizeof(msgQueueDepth));

	snmp_varlist_add_variable(&var_list,
			kamailioMsgQueueMajorThreshold_oid,
			OID_LENGTH(kamailioMsgQueueMajorThreshold_oid),
			ASN_INTEGER,
			(u_char *)&majorThreshold,
			sizeof(majorThreshold));

	send_v2trap( var_list );
	snmp_free_varbind( var_list );

	return SNMP_ERR_NOERROR;
}


/*
 * Sends off an kamailioDialogLimitMinorEvent trap to the master agent,
 * assigning the following variable bindings:
 *
 *  - kamailioCurNumDialogs             = numDialogs
 *  - kamailioDialogLimitMinorThreshold = threshold
 *
 */
int send_kamailioDialogLimitMinorEvent_trap(int numDialogs, int threshold)
{
	netsnmp_variable_list  *var_list = NULL;

	oid kamailioDialogLimitMinorEvent_oid[]    = { 
		KAMAILIO_OID,3,1,3,2,0,3 };
	
	oid kamailioCurNumDialogs_oid[]            = { 
		KAMAILIO_OID,3,1,3,1,3,2,1, 0 };
	
	oid kamailioDialogLimitMinorThreshold_oid[] = { 
		KAMAILIO_OID,3,1,3,1,3,2,5, 0 };

	snmp_varlist_add_variable(&var_list,
		snmptrap_oid,
		OID_LENGTH(snmptrap_oid), 
		ASN_OBJECT_ID,
		(u_char *)kamailioDialogLimitMinorEvent_oid,
		(int)sizeof(kamailioDialogLimitMinorEvent_oid));
	
	snmp_varlist_add_variable(&var_list,
		kamailioCurNumDialogs_oid, 
		OID_LENGTH(kamailioCurNumDialogs_oid),
		ASN_GAUGE,
		(u_char *)&numDialogs,
		sizeof(numDialogs));

	snmp_varlist_add_variable(&var_list,
		kamailioDialogLimitMinorThreshold_oid, 
		OID_LENGTH(kamailioDialogLimitMinorThreshold_oid),
		ASN_INTEGER,
		(u_char *)&threshold,
		sizeof(threshold));

	send_v2trap( var_list );
	snmp_free_varbind( var_list );

	return SNMP_ERR_NOERROR;
}


/*
 * Sends off an kamailioDialogLimitMinorEvent trap to the master agent,
 * assigning the following variable bindings:
 *
 *  - kamailioCurNumDialogs             = numDialogs
 *  - kamailioDialogLimitMinorThreshold = threshold
 *
 */
int send_kamailioDialogLimitMajorEvent_trap(int numDialogs, int threshold)
{
	netsnmp_variable_list  *var_list = NULL;

	oid kamailioDialogLimitMajorEvent_oid[]     = { 
		KAMAILIO_OID,3,1,3,2,0,4 };

	oid kamailioCurNumDialogs_oid[]             = { 
		KAMAILIO_OID,3,1,3,1,3,2,1, 0 };

	oid kamailioDialogLimitMajorThreshold_oid[] = { 
		KAMAILIO_OID,3,1,3,1,3,2,6, 0 };

	snmp_varlist_add_variable(&var_list,
		snmptrap_oid, 
		OID_LENGTH(snmptrap_oid),
		ASN_OBJECT_ID,
		(u_char *)kamailioDialogLimitMajorEvent_oid, 
		(int)sizeof(kamailioDialogLimitMajorEvent_oid));
	
	snmp_varlist_add_variable(&var_list,
		kamailioCurNumDialogs_oid, 
		OID_LENGTH(kamailioCurNumDialogs_oid),
		ASN_GAUGE,
		(u_char *)&numDialogs,
		sizeof(numDialogs));

	snmp_varlist_add_variable(&var_list,
		kamailioDialogLimitMajorThreshold_oid, 
		OID_LENGTH(kamailioDialogLimitMajorThreshold_oid),
		ASN_INTEGER,
		(u_char *)&threshold,
		sizeof(threshold));

	send_v2trap( var_list );
	snmp_free_varbind( var_list );

	return SNMP_ERR_NOERROR;
}
