'use strict';

const { isWindows, isIBMi, mustCall, skip } = require('../common');
const { throws } = require('assert');
const { isMainThread, Worker } = require('worker_threads');

if (isWindows || isIBMi) {
  skip('process.execve is not available in Windows or IBM i');
}

if (isMainThread) {
  new Worker(__filename);
} else {
  throws(mustCall(() => {
    process.execve(
      process.execPath,
      [__filename, 'replaced'],
      { ...process.env, EXECVE_A: 'FIRST', EXECVE_B: 'SECOND', CWD: process.cwd() }
    );
  }), { name: 'TypeError', code: 'ERR_WORKER_UNSUPPORTED_OPERATION' });
}
