/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_PARSERNG_H_
#define _OPENCTL_PARSERNG_H_

#include <GTLCore/String.h>

#include "GTLCore/ParserBase_p.h"
#include <OpenCTL/Export.h>

namespace OpenCTL {
  class Compiler;
  class LexerNG;
  /**
   * @internal
   * @ingroup OpenCTL
   *
   * Parser for CTL files.
   */
  class OPENCTL_TESTS_EXPORT ParserNG : public GTLCore::ParserBase {
    public:
      ParserNG(Compiler* compiler, LexerNG* lexer);
      virtual ~ParserNG();
      virtual GTLCore::AST::Tree* parse();
    private:
    // Parse functions
      void parseModuleHeader();
      void parseModuleBody();
    protected:
      virtual GTLCore::AST::Statement* parseStatement();
      virtual GTLCore::AST::Tree* tree();
    private:
      struct Private;
      Private* const d;
  };
}

#endif
