/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_METADATA_VALUE_ENTRY_H_
#define _GTLCORE_METADATA_VALUE_ENTRY_H_

#include <GTLCore/Metadata/Entry.h>

namespace GTLCore {
  class Value;
  namespace Metadata {
    /**
     * @ingroup GTLCore_Metadata
     * Represent a value (an integer, float, vector...) for a parameter.
     */
    class GTLCORE_EXPORT ValueEntry : public Entry {
        friend class Factory;
        GTL_NO_COPY(ValueEntry);
        ValueEntry( const GTLCore::String& _name, const GTLCore::Value& _value );
        virtual ~ValueEntry();
      public:
        virtual const ValueEntry* asValueEntry() const;
        /**
         * @return the value
         */
        const GTLCore::Value& value() const;
      private:
        struct Private;
        Private* const d;
    };
  }
} 

#endif
