%feature("docstring") OT::CrossEntropyImportanceSampling
"Cross-Entropy Importance Sampling algorithm.

See also
--------
StandardSpaceCrossEntropyImportanceSampling, PhysicalSpaceCrossEntropyImportanceSampling, CrossEntropyResult

Notes
-----
This class inherits from :class:`~openturns.EventSimulation`.

The principle is to perform a simulation study to evaluate the threshold exceedance probability according to an importance density obtained using Cross Entropy algorithm.

A CrossEntropyImportanceSampling object can be created only through its derivative classes,
:class:`~openturns.StandardSpaceCrossEntropyImportanceSampling` or :class:`~openturns.PhysicalSpaceCrossEntropyImportanceSampling`."

// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::getInputSample
"Input sample accessor.

Parameters
----------
step : int
    Iteration index
select : int, optional
    Selection flag:

    - EVENT0 : points not realizing the event are selected
    - EVENT1 : points realizing the event are selected
    - BOTH : all points are selected (default)

Returns
-------
inputSample : :class:`~openturns.Sample`
    Input sample."

// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::getOutputSample
"Output sample accessor.

Parameters
----------
step : int
    Iteration index
select : int, optional
    Selection flag:

    - EVENT0 : points not realizing the event are selected
    - EVENT1 : points realizing the event are selected
    - BOTH : all points are selected (default)

Returns
-------
outputSample : :class:`~openturns.Sample`
    Output sample."


// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::getThresholdPerStep
"Threshold accessor.

Returns
-------
threshold : :class:`~openturns.Point`
    Threshold values at each step."

// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::getStepsNumber
"Subset steps number accessor.

Returns
-------
n : int
    Number of subset steps, including the initial Monte Carlo sampling."

// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::getQuantileLevel
"Accessor to the intermediate quantile level.

Returns
-------
quantileLevel : float
    Result of Cross Entropy algorithm."

// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::setQuantileLevel
"Accessor to the intermediate quantile level.

Parameters
----------
quantileLevel : float
    Intermediate quantile level, must belong to the interval (0,1)."
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::getResult
"Accessor to the intermediate quantile level.

Returns
-------
CrossEntropyResult : :class:`~openturns.CrossEntropyResult`
    Contains all the results of the Cross Entropy algorithm simulation."
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::CrossEntropyImportanceSampling::setKeepSample
"Sample storage accessor.

Parameters
----------
keepsample : bool
    Whether to keep the working samples at each iteration."
    
        
