///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/scene/animation/controller/StandardControllers.h>
#include <core/scene/animation/controller/Controller.h>
#include <core/scene/animation/AnimManager.h>
#include <core/undo/UndoManager.h>

namespace Core {

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(ConstFloatController, FloatController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(ConstIntegerController, IntegerController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(ConstVectorController, VectorController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(ConstBooleanController, BooleanController)

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(LinearFloatController, FloatController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(LinearIntegerController, IntegerController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(LinearVectorController, VectorController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(LinearPositionController, PositionController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(LinearRotationController, RotationController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(LinearScalingController, ScalingController)

//IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(SplineFloatController, FloatController)
//IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(SplineVectorController, VectorController)
IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(SplinePositionController, PositionController)
//IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(SplineRotationController, RotationController)
//IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(SplineScalingController, ScalingController)

};
