/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HashSet {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private ArrayList entryCache;

    public HashSet() {
        this(20, 0.75f);
    }

    public HashSet(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.entryCache = new ArrayList(n);
    }

    public HashSet(int n) {
        this(n, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && (object == entry.value || object.equals(entry.value))) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public void retainAll(HashSet hashSet) {
        if (hashSet == null) {
            return;
        }
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                if (!hashSet.contains(entry.value)) {
                    this.remove(entry.value);
                }
                entry = entry2;
            }
        }
    }

    public void retainAll(HashSet hashSet, HashSet hashSet2) {
        if (hashSet == null) {
            return;
        }
        if (hashSet2 == null) {
            this.retainAll(hashSet);
        } else {
            for (int i = 0; i < this.table.length; ++i) {
                Entry entry = this.table[i];
                while (entry != null) {
                    Entry entry2 = entry.next;
                    if (!hashSet.contains(entry.value)) {
                        hashSet2.add(entry.value);
                        this.remove(entry.value);
                    }
                    entry = entry2;
                }
            }
        }
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        int n = object.hashCode();
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && (object == entry.value || object.equals(entry.value))) {
                return false;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = this.getNewEntry();
        entry.set(n, object, entryArray[n2]);
        entryArray[n2] = entry;
        ++this.count;
        return true;
    }

    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && (object == entry.value || object.equals(entry.value))) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                entry.value = null;
                this.releaseEntry(entry);
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    public void clear() {
        if (this.count == 0) {
            return;
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            if (entry == null) continue;
            while (entry.next != null) {
                entry.value = null;
                this.releaseEntry(entry);
                Entry entry2 = entry.next;
                entry.next = null;
                entry = entry2;
            }
            entry.value = null;
            this.releaseEntry(entry);
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean addAll(HashSet hashSet) {
        boolean bl = false;
        Entry[] entryArray = hashSet.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (this.add(entry.value)) {
                    bl = true;
                }
                entry = entry.next;
            }
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.remove(e)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(HashSet hashSet) {
        boolean bl = false;
        Entry[] entryArray = hashSet.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (this.remove(entry.value)) {
                    bl = true;
                }
                entry = entry.next;
            }
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.count];
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectArray[n++] = entry.value;
                entry = entry.next;
            }
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.count;
        if (objectArray.length < n) {
            Class<?> clazz = objectArray.getClass();
            objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n);
        }
        int n2 = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectArray[n2++] = entry.value;
                entry = entry.next;
            }
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HashSet)) {
            return false;
        }
        HashSet hashSet = (HashSet)object;
        if (hashSet.size() != this.size()) {
            return false;
        }
        boolean bl = true;
        block0: for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (!hashSet.contains(entry.value)) {
                    bl = false;
                    continue block0;
                }
                entry = entry.next;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                n += entry.value.hashCode();
                entry = entry.next;
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                stringBuffer.append(entry.value);
                if (++n < this.count) {
                    stringBuffer.append(", ");
                }
                entry = entry.next;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    private Entry getNewEntry() {
        int n = this.entryCache.size();
        Entry entry = n == 0 ? new Entry() : (Entry)this.entryCache.remove(n - 1);
        return entry;
    }

    private void releaseEntry(Entry entry) {
        this.entryCache.add(entry);
    }

    private static class Entry {
        int hash;
        Object value;
        Entry next;

        protected Entry() {
        }

        protected Entry(int n, Object object, Entry entry) {
            this.hash = n;
            this.value = object;
            this.next = entry;
        }

        protected void set(int n, Object object, Entry entry) {
            this.hash = n;
            this.value = object;
            this.next = entry;
        }
    }
}

