# Picviz - Parallel coordinates ploter
# Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself, either Perl version 5.10.0 or,
# at your option, any later version of Perl 5 you may have available.
#

package Picviz::Dshield;

use 5.010000;
use strict;
use warnings;

require Exporter;
use AutoLoader qw(AUTOLOAD);

use LWP::Simple;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Picviz::Dshield ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(

) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(

);

our $VERSION = '0.01';


# Preloaded methods go here.
sub ip_trend_get
{
	my $IPURL="http://www.wallinfire.net/ipsascii.txt";

	my $browser = LWP::UserAgent->new();
	$browser->timeout(10);

	my $request = HTTP::Request->new(GET => $IPURL);
	my $response = $browser->request($request);
	if ($response->is_error()) {
		printf "Error: %s\n", $response->status_line;
		exit(1);
	}
	return $response->content();
}

sub port_trend_get
{
	my $IPURL="http://www.wallinfire.net/portreportascii.txt";

	my $browser = LWP::UserAgent->new();
	$browser->timeout(10);

	my $request = HTTP::Request->new(GET => $IPURL);
	my $response = $browser->request($request);
	if ($response->is_error()) {
		printf "Error: %s\n", $response->status_line;
		exit(1);
	}
	return $response->content();
}

sub new
{
	my($class, $name) = @_;
	my $iptrends = ip_trend_get();
	my $porttrends = port_trend_get();
	my $self = { iptrends => $iptrends, porttrends => $porttrends };
	bless($self, $class);
	return $self;
}

sub make_zeroed_str
{
	my @args = shift(@_);

	my $str = "$args[0]";

	if (($args[0] < 100) and ($args[0] >= 10) ) {
		$str = "0$args[0]";
	} elsif ($args[0] < 10) {
		$str = "00$args[0]";
	}

	return $str;
}

sub normalize_ip
{
	my @args = shift(@_);

	my @quads = split(/\./, $args[0]);

	my $q0 = make_zeroed_str($quads[0]);
	my $q1 = make_zeroed_str($quads[1]);
	my $q2 = make_zeroed_str($quads[2]);
	my $q3 = make_zeroed_str($quads[3]);

	return "$q0.$q1.$q2.$q3";
}

sub ip_check
{
	my $self=shift;
	my @args = shift(@_);

	my $searchip = normalize_ip($args[0]);

	die "called without a reference" if (!ref($self));

	my @iplist = split('\n', $self->{iptrends});

	foreach my $ipline (@iplist) {
		if ($ipline !~ m/^#/) { # This is not a comment, we can go on
			my @ipdata = split('\t', $ipline);
			if ("$ipdata[0]" eq "$searchip") {
				return @ipdata;
			}
		}
	}

	return 0;
}

sub port_check
{
	my $self=shift;
	my @args = shift(@_);

	die "called without a reference" if (!ref($self));

	my @portlist = split('\n', $self->{porttrends});

	foreach my $portline (@portlist) {
		if (($portline !~ m/^#/) or ($portline !~ m/^port/)) { # This is not a comment, we can go on
			my @portdata = split('\t', $portline);
			if ("$portdata[0]" eq "$args[0]") {
				return @portdata;
			}
		}
	}

	return 0;
}

#sub get_today
#{
#	my $self=shift;
#	die "called without a reference" if (!ref($self));
#
#	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime time;
#	$year += 1900;
#	$mon  += 1;
#
#	if ($mon < 10) {
#	        $strmon = "0$mon";
#	} else {
#	        $strmon = "$mon";
#	}
#
#	print "$year-$strmon-$mday";
#}


# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

Picviz::Dshield - Perl extension for Picviz to query Dshield when generating PCV files.

=head1 SYNOPSIS

  use Picviz::Dshield;

=head1 DESCRIPTION

Retrieves information from www.dshield.org to make it match with your other scripts
if you have an IP address or a target port that is the same than what's seen there.

=head2 EXPORT

None by default.



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

Sebastien Tricaud, E<lt>toady@gscore.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Sebastien Tricaud

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.10.0 or,
at your option, any later version of Perl 5 you may have available.


=cut


