% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr.R
\name{zap_srcref}
\alias{zap_srcref}
\title{Zap source references}
\usage{
zap_srcref(x)
}
\arguments{
\item{x}{An R object. Functions and calls are walked recursively.}
}
\description{
There are a number of situations where R creates source references:
\itemize{
\item Reading R code from a file with \code{source()} and \code{parse()} might save
source references inside calls to \code{function} and \verb{\{}.
\item \code{\link[=sys.call]{sys.call()}} includes a source reference if possible.
\item Creating a closure stores the source reference from the call to
\code{function}, if any.
}

These source references take up space and might cause a number of
issues. \code{zap_srcref()} recursively walks through expressions and
functions to remove all source references.
}
