# Announce: Rakudo compiler, Release #134 (2020.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2020 release of Rakudo #134. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.02:
  + Changes:
    + `throws-like` sub from `Test` module now throws an exception on
      Bool:D matchers [f4ad0c2e][50f084d8][5696dbd1]
    + `RAKUDOLIB` environment variable now mentioned in `--help` [f9b7de22]
    + `Supply.repeated` now has `unique` rather than `squish` semantics [05213315]
  + Fixes:
    + Fix mixing in Raku-level code to the grammar [992f1b83]
    + Fixed concurrency issue with re-checking a precomp file's dependencies [f5ce80e1]
    + Ensure Rakudo can be located in a path with Unicode characters on Windows [4c6cd035]
    + Smart matching a `Regex` no longer breaks if `$/` is not a container [b777d6ff]
    + `raku -v` now mentions `Raku` as the languages [15621b8e]
    + Fixed typecheck on bound attributes (`is built(:bind)`)
      [4b64338a][89203438][8a46fca4][d75a703f]
    + Fixed location of REPL history and made the `RAKUDO_HIST`
      environment variable work [c5c98dea][94713af7]
    + Fixed problem with `.rotor` when given a `Seq` [c7e0df64]
    + Restored exact stringification behaviour of `index`, `indices`, `contains` on `List` [21762929]
    + Improved invalid TypeSmiley error message [246f20db]
    + Assume 1 core is always available in case `nqp::cpucores` fails [1a7f16bc]
    + `Lock.protect` now allows return of a container [b90bebae]
    + Fixed `Parameter.raku`'s handling of default values [21b80974][2aa4d095]
    + Work around spurious error in `Lock::Async` that
      could lead to crashing [d18d6e9a][28541444]
    + Fixed handle leak when chaining `Proc::Async` [cdbd60c1]
    + Restore creating a `Parameter` instance using named arguments [b2c809e4]
    + Fixed behavior of `eqv` operator on two `Seq` objects [76187b57]
    + Fixed variable declared by shape match in signature [ca78390e]
    + Fixed calling of a module sub without `&` and parentheses [e1faa704]
    + Fixed consuming of all `Channel` values which has prevented
      reusing it in multiple react blocks [6fbfc4a0]
    + Fixed usage of `$^a` withing a substitution regex [50ca2ed9][adb85e44]
    + Fixed clonning of multi-dim arrays [4a954cbc]
    + Fixed `$*USER` and other dynamic variables coercion for some buggy cases [3a86272e]
    + Fixed internal compiler error on parameter re-declaration [3498c540]
    + Fixed unhandled exceptions in REPL [6bf227d0]
    + Fixed stringification if `Signature` for some edge cases [b2962b1f][56ccd132]
    + Fixed `is rw` trait application to roles [4de852e4][85660c8f]
    + Improved error message when putting a positional parameter after a named one [8dcf1a8e]
    + Improved error message when referring to a non-existent class whose name contains a `::` [ca1e51c8]
    + Improved error message for Buf stringification [539e96c2][3f637af9]
    + Made sure `Version` objects can coerce themselves [5eb113b1]
    + Various fixes for JVM backend [a08f0439][5984ce98]
  + Additions:
    + Enable user-defined chaining operators to work [d027ee0c]
    + Added `prefix` and `suffix` methods to `Parameter` class which return
      textual prefix and suffix of the parameter [bd68955b]
    + Made an improperly typed default for an attribute a compile time error
      [d8e859d0][05b5f81b][a8bb85a0][b6fa5f5d][13c9da97][4c0761a5][c592b80e]
    + Added `SetHash.set` and `SetHash.unset` methods [6df78ca3]
    + Added `BagHash.add` and `BagHash.remove` methods [c1b8ff60]
    + `Str.contains` now also can take a `Regex` [c3c5dae1]
    + Add `:i(ignorecase)` and `:m(ignoremark)` support to
      `index`, `starts-with`, `ends-with`, `contains`, `substr-eq`, `indices`
      [49aaa6ff][60b0d86a][84987742][0b2236a1][d91c773a][2e3c091c][46ef7f48]
      [9f710029][19576d6c][90fc61bb][ec13c3d0][ea44c194][327c74a6][73c5a25e]
      [d49a418e][5a716a39][7cb04813][0761a882][b140d7a9][c2e608b2][a6acfd0a]
      [aefc851b][597288be][b32048df]
    + The `IterationBuffer` class now has a `Seq` method [c87f5df9]
    + The `Compiler` class now has a `backend` method [61b416ed]
    + The `Match` class now has a `replace-with` method
      [b43c839a][1ac3c5c0][7f3e852f][cd4ab4f3][930e5182]
      [488feafc][b4e00120]
    + `Cool.subst` doesn't need a replacement string anymore [dfb563af]
    + `Supply.first` now also works without a matcher [57dbc358]
    + Properly show enums, subsets and routine return type in `Pod::To::Text` output
      [f60d9694][91f89435][0b0a1aad]
    + Added `iterator` implementation for `Junction` (fixes e.g. calling `^name` on a Junction) [bceaeb1a]
  + Removals:
    + Remove deprecated support for implicit `Distribution::Builder` prefix [593db2d7]
  + Build system:
    + Implement an automated pipeline to create precompiled releases
      [6504be7b][d01d4b26][aaf9a93e][8c995feb]
    + Implement `--git-cache-dir` Configure.pl option.
      It can save time and bandwidth when doing more than one build [322b095e][ac6c4379]
    + Add a `--build-only` option for `install-dist.p6` script [4c6c0278]
    + made building optional when installing in `install-dist.p6` script [411db10e]
  + Efficiency:
    + Simplify exception throwing in bootstrap [d18c69b2]
    + Made `Seq.list` return cached list if present [8ccfa87e]
    + Made `.List` and `.Slip` more efficient [d1d931a7]
    + Made `Str.comb(Regex)` about 1.8x as fast [9e8adb65][4df7472d]
    + Made `Str.split(Regex)` about 15% faster [931f5ae0][ba2c58a3]
    + Made `Supply.unique` a few percent faster [32bd4ed8]
    + Made internal `Match` stringification a few percent faster [495ddcc1]
    + Made various aspects of `Date` and `DateTime` faster
      [076ef98b][ced67b83][b086a9f2][99b67a4b][e979f173][af8cca77]
      [65d0422b][b19c4eec][fa7d3bf7][16962c84][c0e8091e][0286904b]
    + Made `Date.new(Str)` about 9.8x as fast [0408d6e4][497afdad]
    + Made `Date.new(Instant)` about 12.5x as fast [f91a1616]
    + Made `Date.today` about 4.5x as fast [1d7a9168][7a2d68f8][13444198][8876e035]
    + Made `Date.earlier` / `Date.later` between 1.5x and 5.5x as fast [4ebbddfb][5943cbfe]
    + Made `Date.succ` / `Date.pred` (used in ++ and --) about 2.8x as fast [9707384c]
    + Made `Date` integer arithmetic about 2.3x as fast [cfe2cdc5]
    + Made `Date.Str` about 250x as fast with the default formatter [67022d4c]
    + Made `DateTime.new(Str)` about 30% faster [578935e6]
    + Made `DateTime.Str` about 90x as fast with the default formatter [a331ac4d][2b7d5ffe]
    + Made `Instant.new` a few percent faster [5b97ddef][bd948ba3]
    + Made creation of a `Junction` about 3.5x as fast [470f7fd0]
    + Made `Junction.defined` between 15% and 40% faster [7a561d63][423d9ad8][6844be9d]
    + `Hash.DELETE-KEY` does one less hash lookup [9217b1c7]
    + Made various aspects of `Proc::Async` faster [0c5a7075][ca49dcbd][1db41618][356bf3f7][05916efa]
    + Made `Channel.list` around 16x faster [82bd76f1]
  + Internal:
    + Preparations for UNIX sockets support [7c7d3b96][1a5b2185][ed4226d7][ce5b5dea][62cb756d]
    + Simplify leap date updating logic [25c84b3a][bdb00749]
    + Removed perlcritic config file [5ac792ac]
    + Add support for `use BUILDPLAN class` [8fdce756]
    + Add support for nqp arrays to `dd` [255318ec]
    + Change of `IO::Path!new-from-absolute-path` internal method signature [1d946e15]
    + Correctly set up values for `$*DISTRO` initialization [22d5ffc3]
    + Change file extensions to Raku format
      [61821ffa][8c242d5e][582c14a8][5e9d98c2][ea1cb407][3b8104ec]
      [4677f741][ac652c0e][e5723208][deac4407][7b679604][416fd513]
      [ca99c7ca][54375179][82ea3292][4ec31e2c]
    + Other internal changes related to Perl 6 -> Raku migration
      [10e5390b][8fd7172c][af292586][81014e78][925e73df][dd7b4ce5]
    + Tests added [21320191][ffabf8d5]
    + Remove unused `nqp::p6decodelocaltime` as NQP has `nqp::decodelocaltime` [e2ba546f][663c427e]
    + Rename the `Junction` `$!storage` attribute to `$!eigenstates` [1a6f83c6][911cac4e]
    + Simplify fetching of the kept `Promise` sentinel in `Lock::Async` [e81e5162]
    + Simplify `Parameter.raku` implementation and improve how it handles parametert names [3f6a2a22]
    + Added `*_RUNNER_OPTS` variable to Makefiles [701c38df]
    + Make `rakudo` binaries default ones and `perl6` to be aliases,
      as well as include some other renaming-related changes
      [f5f6f76f][23ca6952][519a741a][536a2d28]

The following people contributed to this release:

Elizabeth Mattijsen, Juan Julián Merelo Guervós, Jonathan Worthington,
Stoned Elipot, Vadim Belman, Patrick Böker, Daniel Green, Will "Coke"
Coleda, Alexander Kiryuhin, Ben Davies, Stefan Seifert, Trey Harris,
Christian Bartolomäus, Josh Soref, Aleks-Daniel Jakimenko-Aleksejev,
Brian Duggan, Luis F. Uceta, Mikhail Khorkov, Tom Browder, Jan-Olof Hendig,
Jeremy Studer, Konrad Bucheli, Rod Taylor, Samantha McVey, Bahtiar Gadimov,
Ven de Thiel.

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or find out more information, visit
<https://raku.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#135), is tentatively scheduled for 2020-03-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
