# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Crestron.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.devsettings


# interface
class Crestron(Interface):
    idlType = "devsettings.Crestron:1.0.0"

    # structure
    class Settings(Structure):
        idlType = "devsettings.Crestron.Settings:1.0.0"
        elements = ["enableXioCloudConnection"]

        def __init__(self, enableXioCloudConnection=False):
            typecheck.is_bool(enableXioCloudConnection, AssertionError)

            self.enableXioCloudConnection = enableXioCloudConnection

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enableXioCloudConnection = json['enableXioCloudConnection'] if 'enableXioCloudConnection' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['enableXioCloudConnection'] = self.enableXioCloudConnection
            return json

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Crestron.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Crestron.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.devsettings.Crestron.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.devsettings.Crestron.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(Crestron, self).__init__(target, agent)
        self.getSettings = Crestron._getSettings(self)
        self.setSettings = Crestron._setSettings(self)

#
# Section generated by IdlC from "Modbus.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.devsettings


# interface
class Modbus(Interface):
    idlType = "devsettings.Modbus:2.0.0"

    ERR_INVALID_PARAM = 1

    # structure
    class Capabilities(Structure):
        idlType = "devsettings.Modbus_2_0_0.Capabilities:1.0.0"
        elements = ["hasModbusSerial"]

        def __init__(self, hasModbusSerial=False):
            typecheck.is_bool(hasModbusSerial, AssertionError)

            self.hasModbusSerial = hasModbusSerial

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                hasModbusSerial = json['hasModbusSerial'] if 'hasModbusSerial' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['hasModbusSerial'] = self.hasModbusSerial
            return json

    class _getCapabilities(Interface.Method):
        name = 'getCapabilities'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Modbus.Capabilities.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Modbus.Capabilities, DecodeException)
            return _ret_

    # structure
    class TcpSettings(Structure):
        idlType = "devsettings.Modbus_2_0_0.TcpSettings:1.0.0"
        elements = ["readonly"]

        def __init__(self, readonly=False):
            typecheck.is_bool(readonly, AssertionError)

            self.readonly = readonly

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                readonly = json['readonly'] if 'readonly' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['readonly'] = self.readonly
            return json

    # enumeration
    class Parity(Enumeration):
        idlType = "devsettings.Modbus_2_0_0.Parity:1.0.0"
        values = ["NONE", "EVEN", "ODD"]

    Parity.NONE = Parity(0)
    Parity.EVEN = Parity(1)
    Parity.ODD = Parity(2)

    # structure
    class SerialSettings(Structure):
        idlType = "devsettings.Modbus_2_0_0.SerialSettings:1.0.0"
        elements = ["enabled", "baudrate", "parity", "stopbits", "readonly"]

        def __init__(self, enabled=False, baudrate=0, parity=None, stopbits=0, readonly=False):
            if parity is None:
                parity = raritan.rpc.devsettings.Modbus.Parity.NONE
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_int(baudrate, AssertionError)
            typecheck.is_enum(parity, raritan.rpc.devsettings.Modbus.Parity, AssertionError)
            typecheck.is_int(stopbits, AssertionError)
            typecheck.is_bool(readonly, AssertionError)

            self.enabled = enabled
            self.baudrate = baudrate
            self.parity = parity
            self.stopbits = stopbits
            self.readonly = readonly

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                baudrate = json['baudrate'] if 'baudrate' in json or not useDefaults else 0,
                parity = raritan.rpc.devsettings.Modbus.Parity.decode(json['parity']) if 'parity' in json or not useDefaults else raritan.rpc.devsettings.Modbus.Parity.NONE,
                stopbits = json['stopbits'] if 'stopbits' in json or not useDefaults else 0,
                readonly = json['readonly'] if 'readonly' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['baudrate'] = self.baudrate
            json['parity'] = raritan.rpc.devsettings.Modbus.Parity.encode(self.parity)
            json['stopbits'] = self.stopbits
            json['readonly'] = self.readonly
            return json

    # structure
    class Settings(Structure):
        idlType = "devsettings.Modbus_2_0_0.Settings:1.0.0"
        elements = ["tcp", "serial", "primaryUnitId"]

        def __init__(self, tcp=None, serial=None, primaryUnitId=0):
            if tcp is None:
                tcp = raritan.rpc.devsettings.Modbus.TcpSettings()
            if serial is None:
                serial = raritan.rpc.devsettings.Modbus.SerialSettings()
            typecheck.is_struct(tcp, raritan.rpc.devsettings.Modbus.TcpSettings, AssertionError)
            typecheck.is_struct(serial, raritan.rpc.devsettings.Modbus.SerialSettings, AssertionError)
            typecheck.is_int(primaryUnitId, AssertionError)

            self.tcp = tcp
            self.serial = serial
            self.primaryUnitId = primaryUnitId

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                tcp = raritan.rpc.devsettings.Modbus.TcpSettings.decode(json['tcp'], agent, useDefaults=useDefaults) if 'tcp' in json or not useDefaults else raritan.rpc.devsettings.Modbus.TcpSettings(),
                serial = raritan.rpc.devsettings.Modbus.SerialSettings.decode(json['serial'], agent, useDefaults=useDefaults) if 'serial' in json or not useDefaults else raritan.rpc.devsettings.Modbus.SerialSettings(),
                primaryUnitId = json['primaryUnitId'] if 'primaryUnitId' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['tcp'] = raritan.rpc.devsettings.Modbus.TcpSettings.encode(self.tcp)
            json['serial'] = raritan.rpc.devsettings.Modbus.SerialSettings.encode(self.serial)
            json['primaryUnitId'] = self.primaryUnitId
            return json

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Modbus.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Modbus.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.devsettings.Modbus.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.devsettings.Modbus.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Modbus, self).__init__(target, agent)
        self.getCapabilities = Modbus._getCapabilities(self)
        self.getSettings = Modbus._getSettings(self)
        self.setSettings = Modbus._setSettings(self)

#
# Section generated by IdlC from "Redfish.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.devsettings


# interface
class Redfish(Interface):
    idlType = "devsettings.Redfish:1.0.0"

    # structure
    class Settings(Structure):
        idlType = "devsettings.Redfish.Settings:1.0.0"
        elements = ["enabled"]

        def __init__(self, enabled=False):
            typecheck.is_bool(enabled, AssertionError)

            self.enabled = enabled

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            return json

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Redfish.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Redfish.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.devsettings.Redfish.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.devsettings.Redfish.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(Redfish, self).__init__(target, agent)
        self.getSettings = Redfish._getSettings(self)
        self.setSettings = Redfish._setSettings(self)

#
# Section generated by IdlC from "Smtp.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.devsettings


# interface
class Smtp(Interface):
    idlType = "devsettings.Smtp:2.0.0"

    ERR_INVALID_PARAMS = 1

    # structure
    class Configuration(Structure):
        idlType = "devsettings.Smtp_2_0_0.Configuration:1.0.0"
        elements = ["host", "port", "useTls", "allowOffTimeRangeCerts", "caCertChain", "sender", "useAuth", "username", "password", "retryCount", "retryInterval"]

        def __init__(self, host="", port=0, useTls=False, allowOffTimeRangeCerts=False, caCertChain="", sender="", useAuth=False, username="", password="", retryCount=0, retryInterval=0):
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_int(port, AssertionError)
            typecheck.is_bool(useTls, AssertionError)
            typecheck.is_bool(allowOffTimeRangeCerts, AssertionError)
            if not typecheck._is_int(caCertChain):
                typecheck.is_string(caCertChain, AssertionError)
            if not typecheck._is_int(sender):
                typecheck.is_string(sender, AssertionError)
            typecheck.is_bool(useAuth, AssertionError)
            if not typecheck._is_int(username):
                typecheck.is_string(username, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_int(retryCount, AssertionError)
            typecheck.is_int(retryInterval, AssertionError)

            self.host = host
            self.port = port
            self.useTls = useTls
            self.allowOffTimeRangeCerts = allowOffTimeRangeCerts
            self.caCertChain = caCertChain
            self.sender = sender
            self.useAuth = useAuth
            self.username = username
            self.password = password
            self.retryCount = retryCount
            self.retryInterval = retryInterval

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                host = json['host'] if 'host' in json or not useDefaults else "",
                port = json['port'] if 'port' in json or not useDefaults else 0,
                useTls = json['useTls'] if 'useTls' in json or not useDefaults else False,
                allowOffTimeRangeCerts = json['allowOffTimeRangeCerts'] if 'allowOffTimeRangeCerts' in json or not useDefaults else False,
                caCertChain = json['caCertChain'] if 'caCertChain' in json or not useDefaults else "",
                sender = json['sender'] if 'sender' in json or not useDefaults else "",
                useAuth = json['useAuth'] if 'useAuth' in json or not useDefaults else False,
                username = json['username'] if 'username' in json or not useDefaults else "",
                password = json['password'] if 'password' in json or not useDefaults else "",
                retryCount = json['retryCount'] if 'retryCount' in json or not useDefaults else 0,
                retryInterval = json['retryInterval'] if 'retryInterval' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['host'] = str(self.host)
            json['port'] = self.port
            json['useTls'] = self.useTls
            json['allowOffTimeRangeCerts'] = self.allowOffTimeRangeCerts
            json['caCertChain'] = str(self.caCertChain)
            json['sender'] = str(self.sender)
            json['useAuth'] = self.useAuth
            json['username'] = str(self.username)
            json['password'] = str(self.password)
            json['retryCount'] = self.retryCount
            json['retryInterval'] = self.retryInterval
            return json

    class _getConfiguration(Interface.Method):
        name = 'getConfiguration'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Smtp.Configuration.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Smtp.Configuration, DecodeException)
            return _ret_

    class _setConfiguration(Interface.Method):
        name = 'setConfiguration'

        @staticmethod
        def encode(cfg):
            typecheck.is_struct(cfg, raritan.rpc.devsettings.Smtp.Configuration, AssertionError)
            args = {}
            args['cfg'] = raritan.rpc.devsettings.Smtp.Configuration.encode(cfg)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    # structure
    class TestResult(Structure):
        idlType = "devsettings.Smtp_2_0_0.TestResult:1.0.0"
        elements = ["status", "message"]

        def __init__(self, status=0, message=""):
            typecheck.is_int(status, AssertionError)
            if not typecheck._is_int(message):
                typecheck.is_string(message, AssertionError)

            self.status = status
            self.message = message

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                status = json['status'] if 'status' in json or not useDefaults else 0,
                message = json['message'] if 'message' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['status'] = self.status
            json['message'] = str(self.message)
            return json

    class _testConfiguration(Interface.Method):
        name = 'testConfiguration'

        @staticmethod
        def encode(cfg, recipients):
            typecheck.is_struct(cfg, raritan.rpc.devsettings.Smtp.Configuration, AssertionError)
            for x0 in recipients:
                if not typecheck._is_int(x0):
                    typecheck.is_string(x0, AssertionError)
            args = {}
            args['cfg'] = raritan.rpc.devsettings.Smtp.Configuration.encode(cfg)
            args['recipients'] = [str(x0) for x0 in recipients]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Smtp.TestResult.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Smtp.TestResult, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Smtp, self).__init__(target, agent)
        self.getConfiguration = Smtp._getConfiguration(self)
        self.setConfiguration = Smtp._setConfiguration(self)
        self.testConfiguration = Smtp._testConfiguration(self)

#
# Section generated by IdlC from "Snmp.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.devsettings

import raritan.rpc.idl


# interface
class Snmp(Interface):
    idlType = "devsettings.Snmp:1.0.2"

    ERR_INVALID_PARAMS = 1

    # structure
    class Configuration(Structure):
        idlType = "devsettings.Snmp_1_0_2.Configuration:1.0.0"
        elements = ["v2enable", "v3enable", "readComm", "writeComm", "sysContact", "sysName", "sysLocation"]

        def __init__(self, v2enable=False, v3enable=False, readComm="", writeComm="", sysContact="", sysName="", sysLocation=""):
            typecheck.is_bool(v2enable, AssertionError)
            typecheck.is_bool(v3enable, AssertionError)
            if not typecheck._is_int(readComm):
                typecheck.is_string(readComm, AssertionError)
            if not typecheck._is_int(writeComm):
                typecheck.is_string(writeComm, AssertionError)
            if not typecheck._is_int(sysContact):
                typecheck.is_string(sysContact, AssertionError)
            if not typecheck._is_int(sysName):
                typecheck.is_string(sysName, AssertionError)
            if not typecheck._is_int(sysLocation):
                typecheck.is_string(sysLocation, AssertionError)

            self.v2enable = v2enable
            self.v3enable = v3enable
            self.readComm = readComm
            self.writeComm = writeComm
            self.sysContact = sysContact
            self.sysName = sysName
            self.sysLocation = sysLocation

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                v2enable = json['v2enable'] if 'v2enable' in json or not useDefaults else False,
                v3enable = json['v3enable'] if 'v3enable' in json or not useDefaults else False,
                readComm = json['readComm'] if 'readComm' in json or not useDefaults else "",
                writeComm = json['writeComm'] if 'writeComm' in json or not useDefaults else "",
                sysContact = json['sysContact'] if 'sysContact' in json or not useDefaults else "",
                sysName = json['sysName'] if 'sysName' in json or not useDefaults else "",
                sysLocation = json['sysLocation'] if 'sysLocation' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['v2enable'] = self.v2enable
            json['v3enable'] = self.v3enable
            json['readComm'] = str(self.readComm)
            json['writeComm'] = str(self.writeComm)
            json['sysContact'] = str(self.sysContact)
            json['sysName'] = str(self.sysName)
            json['sysLocation'] = str(self.sysLocation)
            return json

    # value object
    class ConfigurationChangedEvent(raritan.rpc.idl.Event):
        idlType = "devsettings.Snmp_1_0_2.ConfigurationChangedEvent:1.0.0"

        def __init__(self, userName="", ipAddr="", oldConfig=None, newConfig=None, source=None):
            super(raritan.rpc.devsettings.Snmp.ConfigurationChangedEvent, self).__init__(source)
            if oldConfig is None:
                oldConfig = raritan.rpc.devsettings.Snmp.Configuration()
            if newConfig is None:
                newConfig = raritan.rpc.devsettings.Snmp.Configuration()
            if not typecheck._is_int(userName):
                typecheck.is_string(userName, AssertionError)
            if not typecheck._is_int(ipAddr):
                typecheck.is_string(ipAddr, AssertionError)
            typecheck.is_struct(oldConfig, raritan.rpc.devsettings.Snmp.Configuration, AssertionError)
            typecheck.is_struct(newConfig, raritan.rpc.devsettings.Snmp.Configuration, AssertionError)

            self.userName = userName
            self.ipAddr = ipAddr
            self.oldConfig = oldConfig
            self.newConfig = newConfig

        def encode(self):
            json = super(raritan.rpc.devsettings.Snmp.ConfigurationChangedEvent, self).encode()
            json['userName'] = str(self.userName)
            json['ipAddr'] = str(self.ipAddr)
            json['oldConfig'] = raritan.rpc.devsettings.Snmp.Configuration.encode(self.oldConfig)
            json['newConfig'] = raritan.rpc.devsettings.Snmp.Configuration.encode(self.newConfig)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                userName = json['userName'] if 'userName' in json or not useDefaults else "",
                ipAddr = json['ipAddr'] if 'ipAddr' in json or not useDefaults else "",
                oldConfig = raritan.rpc.devsettings.Snmp.Configuration.decode(json['oldConfig'], agent, useDefaults=useDefaults) if 'oldConfig' in json or not useDefaults else raritan.rpc.devsettings.Snmp.Configuration(),
                newConfig = raritan.rpc.devsettings.Snmp.Configuration.decode(json['newConfig'], agent, useDefaults=useDefaults) if 'newConfig' in json or not useDefaults else raritan.rpc.devsettings.Snmp.Configuration(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["userName", "ipAddr", "oldConfig", "newConfig"]
            elements = elements + super(raritan.rpc.devsettings.Snmp.ConfigurationChangedEvent, self).listElements()
            return elements

    class _getConfiguration(Interface.Method):
        name = 'getConfiguration'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Snmp.Configuration.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Snmp.Configuration, DecodeException)
            return _ret_

    class _setConfiguration(Interface.Method):
        name = 'setConfiguration'

        @staticmethod
        def encode(cfg):
            typecheck.is_struct(cfg, raritan.rpc.devsettings.Snmp.Configuration, AssertionError)
            args = {}
            args['cfg'] = raritan.rpc.devsettings.Snmp.Configuration.encode(cfg)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getV3EngineId(Interface.Method):
        name = 'getV3EngineId'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            if not typecheck._is_int(_ret_):
                typecheck.is_string(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Snmp, self).__init__(target, agent)
        self.getConfiguration = Snmp._getConfiguration(self)
        self.setConfiguration = Snmp._setConfiguration(self)
        self.getV3EngineId = Snmp._getV3EngineId(self)

#
# Section generated by IdlC from "Zeroconf.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.devsettings

import raritan.rpc.idl


# interface
class Zeroconf(Interface):
    idlType = "devsettings.Zeroconf:2.0.0"

    # structure
    class Settings(Structure):
        idlType = "devsettings.Zeroconf_2_0_0.Settings:1.0.0"
        elements = ["mdnsEnabled", "llmnrEnabled"]

        def __init__(self, mdnsEnabled=False, llmnrEnabled=False):
            typecheck.is_bool(mdnsEnabled, AssertionError)
            typecheck.is_bool(llmnrEnabled, AssertionError)

            self.mdnsEnabled = mdnsEnabled
            self.llmnrEnabled = llmnrEnabled

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                mdnsEnabled = json['mdnsEnabled'] if 'mdnsEnabled' in json or not useDefaults else False,
                llmnrEnabled = json['llmnrEnabled'] if 'llmnrEnabled' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['mdnsEnabled'] = self.mdnsEnabled
            json['llmnrEnabled'] = self.llmnrEnabled
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.idl.Event):
        idlType = "devsettings.Zeroconf_2_0_0.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, source=None):
            super(raritan.rpc.devsettings.Zeroconf.SettingsChangedEvent, self).__init__(source)
            if oldSettings is None:
                oldSettings = raritan.rpc.devsettings.Zeroconf.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.devsettings.Zeroconf.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.devsettings.Zeroconf.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.devsettings.Zeroconf.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.devsettings.Zeroconf.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.devsettings.Zeroconf.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.devsettings.Zeroconf.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.devsettings.Zeroconf.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.devsettings.Zeroconf.Settings(),
                newSettings = raritan.rpc.devsettings.Zeroconf.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.devsettings.Zeroconf.Settings(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.devsettings.Zeroconf.SettingsChangedEvent, self).listElements()
            return elements

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.devsettings.Zeroconf.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.devsettings.Zeroconf.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.devsettings.Zeroconf.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.devsettings.Zeroconf.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(Zeroconf, self).__init__(target, agent)
        self.getSettings = Zeroconf._getSettings(self)
        self.setSettings = Zeroconf._setSettings(self)
