#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:39:08 
# _test-kerberos.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYREALM="$1"
MYDNS="$2"
MYKDC="$3"
MYADMIN="$4"
MYADMINPWD="$5"

### I N C L U D E

. ./_include.sh

## F I L E S
krbconffile=/etc/krb5.conf

### S T A R T

echo "--------------------------------------------------------------------------------"
echo "KERBEROS TEST"
echo "--------------------------------------------------------------------------------"
if [ ! -e /var/lib/sadms/kerberos ]; then
	echo "Kerberos has probably not been configured" >&2
fi

result=0
echo "+LOGIN TO REALM ${MYREALM} (as ${MYADMIN})"
echo "${MYADMINPWD}" | ${KINIT} ${MYADMIN}@${MYREALM} > /dev/null 2>/dev/null
if [ "$?" == "0" ]; then
	echo "ok"
	echo "+KERBEROS (TICKET GRANTING) TICKET"
	${KLIST} -5 | grep "krbtgt/" | awk '{print $5 }'
	exit 0
else
	echo "could not acquire Kerberos ticket" >&2
	echo "${MYADMINPWD}" | ${KINIT} ${MYADMIN}@${MYREALM}
	echo "+WARNING" >&2 
	echo "Kerberos requires administrator's password" >&2 
	echo "to have been reset once since domain install" >&2
	echo "in order to add DES encryption keys to user" >&2
	echo "account which only has a RC4 key when" >&2
	echo "initially created." >&2
	result=1
fi

#echo "+KDC"
#net lookup kdc

echo "--------------------------------------------------------------------------------"
echo "KRB5.CONF"
echo "--------------------------------------------------------------------------------"
echo "{"
grep -v "^#" ${krbconffile} | grep -v "^$"
echo "}"

exit ${result}
