#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:31:48 
# _test-nmb.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYDNS="$1"
MYDOMAIN="$2"
MYDC="$3"
MYSERVER="$4"
MYHOSTALLOW="$5"
MYWINS="$6"

### I N C L U D E

. ./_include.sh

### S T A R T

echo "--------------------------------------------------------------------------------"
echo "NMB TEST"
echo "--------------------------------------------------------------------------------"

function resolve()
{
	if [ "$3" == "all" ]; then
		nmblookup $1 $2 '*'
	else
		nmblookup $1 $2 $3
	fi
}

function resolveAll()
{
	nmblookup '*'
}

function nodeStatus()
{
	echo "node status on $1"
	nmblookup -A $1
	echo "=$?"
}

echo "+PORT LISTENING"
output=`netstat -a | grep netbios`
echo ${output}
echo ${output} | grep 'netbios-ns'
if [ "$?" == "0" ]; then
	echo "name service listening"
else
	echo "name service not listening" >&2
fi
echo "+QUERIES"
resolve -B localhost __SAMBA__
resolve -B ${MYSERVER} all
echo "+QUERY ALL REGISTERED NAMES"
resolveAll
#echo "+QUERY NODE STATUS"
#nodeStatus ${MYSERVER}
#nodeStatus ${MYDC}
