#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:24:21 
# conf/config-netlink.sh

### P A R A M S
MYMOUNTPOINT="$1"
MYSHARE="$2"
#echo "mountpoint=${MYMOUNTPOINT}"
#echo "share=${MYSHARE}"

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
skelprofile=.bash_profile

### ... W I T H   A C C E S S
INST_SKEL_MOD=644
INST_UID=0
INST_GID=0
case ${DISTRIBUTION} in
	Redhat|Fedora|Mandriva)
		INST_XINIT_MOD=755
		;;
	Debian|Ubuntu)
		INST_XINIT_MOD=644
		;;
	*)
		INST_XINIT_MOD=644
		;;
esac

### S O U R C E   F I L E S ...
skelprofileext=_bash_profile-ext

### S T A R T

# C O M P U T E   U S E R N A M E   S E P A R A T O R
#separator=`testparm -sv 2> /dev/null | grep 'winbind separator' | awk '{print $4}'`
#echo "separator=${separator}"

# C O M P U T E   I F   S H A R E   I S   U S E R N A M E
sharebasename=${MYSHARE/*\//}
haveperusersubdir=
if [ "${sharebasename}" != "${MYSHARE}" ]; then
	haveperusersubdir=1
fi
echo "sharebasename=${sharebasename}"
echo "haveperusersubdir=${haveperusersubdir}"

# C U S T O M I Z  E   / E T C / S K E L  / . B A S H _ P R O F I L E

[ -e ${SKELDIR}/${skelprofile} ] || touch  ${SKELDIR}/${skelprofile}

echo "+customize ${SKELDIR}/${skelprofile}"

# check if already there
grep -s "# sadms" ${SKELDIR}/${skelprofile} > /dev/null
case $? in
0)
	# abstain
	echo "sadms is already used in ${SKELDIR}/${skelprofile}"
	;;
*)
	# do it
	echo "add link-making to ${SKELDIR}/${skelprofile}"

	# append blob
	cp ${SKELDIR}/${skelprofile} ${TMPDIR}/${skelprofile}
	echo "# sadms.begin" >> ${TMPDIR}/${skelprofile}
	echo "netmountpoint=${MYMOUNTPOINT}" >> ${TMPDIR}/${skelprofile}
	echo "haveperusersubdir=${haveperusersubdir}" >> ${TMPDIR}/${skelprofile}
	cat ./${skelprofileext} >> ${TMPDIR}/${skelprofile}
	echo "# sadms.end" >> ${TMPDIR}/${skelprofile}
	#cat ${TMPDIR}/${skelprofile}
	
	# install
	echo "install ${skelprofile} to ${SKELDIR}"
	${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_SKEL_MOD} ${TMPDIR}/${skelprofile} ${SKELDIR} > /dev/null
	rm -f ${TMPDIR}/${skelprofile}
	;;
esac

# C U S T O M I Z E   X I N I T R C / X S E S S I O N

echo "+add ${X11DIR}/${XINITRCDIR}/${XINITRCCIFSMOUNT}"
echo "netmountpoint=${MYMOUNTPOINT}" > ${X11DIR}/${XINITRCDIR}/${XINITRCCIFSMOUNT}
echo "haveperusersubdir=${haveperusersubdir}" >> ${X11DIR}/${XINITRCDIR}/${XINITRCCIFSMOUNT}
cat ./${skelprofileext} >> ${X11DIR}/${XINITRCDIR}/${XINITRCCIFSMOUNT}
chmod ${INST_XINIT_MOD} ${X11DIR}/${XINITRCDIR}/${XINITRCCIFSMOUNT}
