
# SAGA - System for Automated Geoscientific Analyses

SAGA is a Geographic Information System (GIS) software with immense capabilities for geodata processing and analysis. SAGA is programmed in the object oriented C++ language and supports the implementation of new functions with a very effective Application Programming Interface (API). Functions are organised as modules in framework independent Module Libraries and can be accessed via SAGA’s Graphical User Interface (GUI) or various scripting environments (shell scripts, Python, R, ...).

___
## Citation
Please provide the following reference in your work if you are using SAGA:

_Conrad, O., Bechtel, B., Bock, M., Dietrich, H., Fischer, E., Gerlitz, L., Wehberg, J., Wichmann, V., and Boehner, J. (2015): System for Automated Geoscientific Analyses (SAGA) v. 2.1.4. Geosci. Model Dev., 8, 1991-2007, [doi:10.5194/gmd-8-1991-2015](https://doi.org/10.5194/gmd-8-1991-2015)._

___
## Links

- [saga-gis.org](https://saga-gis.org)
- [SourceForge](https://sourceforge.net/projects/saga-gis/)
- [Installation](https://sourceforge.net/p/saga-gis/wiki/SAGA%20Installation/)
- [Git Code Repository](git://git.code.sf.net/p/saga-gis/code)
- [Change Logs](https://sourceforge.net/p/saga-gis/wiki/SAGA%20Release%20Information/)
- [User Forum](https://sourceforge.net/p/saga-gis/discussion/790705/)

___
## Supported Platforms

- Microsoft Windows
- Linux
- FreeBSD
- MacOS

___
## Copyright and Licensing

### SAGA API | Application Programming Interface
- GNU Lesser General Public License (LGPL)

### SAGA GUI | Graphical User Interface
- GNU General Public License (GPL)

### SAGA CMD | Command Line Interpreter
- GNU General Public License (GPL)

### SAGA Tools | Tool Libraries and Tool Chains
- GNU General Public License (GPL) or compatible

SAGA is free software. It is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License (GPL) and GNU Lesser General Public License (LGPL) for more details.

You should have received a copy of both licenses along with this program; if not, write to the

    Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor
    Boston, MA 02110-1301, USA

___
## Development

SAGA has been created and developed by O. Conrad

Core team and project administration
- O. Conrad, V. Wichmann

Brought to you by
- J. Böhner, O. Conrad ([Dept. of Physical Geography](https://www.geo.uni-hamburg.de/en/geographie/abteilungen/physische-geographie.html), [Univ. of Hamburg](https://www.uni-hamburg.de/))
- M. Bock, R. Köthe, J. Spitzmüller ([SciLands GmbH](https://www.scilands.de/))
- V. Wichmann ([LASERDATA](https://laserdata.at/))

We also like to thank you for all kind of community contributions like package management, code contributions, bug fix reports, feature suggestions, forum questions and answers, documentation and tutorials, citations and recommendations, ...and for choosing SAGA!
