CHANGELOG for 7.0.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 7.0 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v7.0.0...v7.0.1

* 7.0.10 (2024-07-26)

 * bug #57803 [FrameworkBundle] move adding detailed JSON error messages to the validate phase (xabbuh)
 * bug #57815 [Console][PhpUnitBridge][VarDumper] Fix `NO_COLOR` empty value handling (alexandre-daubois)
 * bug #57828 [Translation] Fix CSV escape char in `CsvFileLoader` on PHP >= 7.4 (alexandre-daubois)
 * bug #57812 [Validator] treat uninitialized properties referenced by property paths as null (xabbuh)
 * bug #57816 [DoctrineBridge] fix messenger bus dispatch inside an active transaction (IndraGunawan)
 * bug #57799 [ErrorHandler][VarDumper] Remove PHP 8.4 deprecations (alexandre-daubois)
 * bug #57772 [WebProfilerBundle] Add word wrap in tables in dialog to see all the text in workflow listeners dialog (SpartakusMd)
 * bug #57802 [PropertyInfo] Fix nullable value returned from extractFromMutator on CollectionType (benjilebon)
 * bug #57832 [DependencyInjection] Do not try to load default method name on interface (lyrixx)
 * bug #57748 [SecurityBundle] use firewall-specific user checkers when manually logging in users (xabbuh)
 * bug #57753 [ErrorHandler] restrict the maximum length of the X-Debug-Exception header (xabbuh)
 * bug #57646 [Serializer] Raise correct exception in `ArrayDenormalizer` when called without a nested denormalizer (derrabus)
 * bug #57674 [Cache] Improve `dbindex` DSN parameter parsing (constantable)
 * bug #57678 [Validator] Add `setGroupProvider` to `AttributeLoader` (Maximilian Zumbansen)
 * bug #57679 [WebProfilerBundle] Change incorrect check for the `stateless` request attribute (themasch)
 * bug #57663 [Cache] use copy() instead of rename() on Windows (xabbuh)
 * bug #57617 [PropertyInfo] Handle collection in PhpStan same as PhpDoc (mtarld)
 * bug #54057 [Messenger] Passing actual `Envelope` to `WorkerMessageRetriedEvent`  (daffoxdev)
 * bug #57645 [Routing] Discard in-memory cache of routes when writing the file-based cache (mpdude)
 * bug #57621 [Mailer]  force HTTP 1.1 for Mailgun API requests (xabbuh)
 * bug #57616 [String] Revert "Fixed u()->snake(), b()->snake() and s()->snake() methods" (nicolas-grekas)
 * bug #57593 [SecurityBundle] Compare paths after realpath() has been applied to both (xabbuh)
 * bug #57594 [String] Normalize underscores in snake() (xabbuh)
 * bug #57585 [HttpFoundation] Fix MockArraySessionStorage to generate more conform ids (Seldaek)
 * bug #57589 [FrameworkBundle] fix AssetMapper usage without assets enabled (xabbuh)

* 7.0.9 (2024-06-28)

 * bug #57345 [DependencyInjection] Fix regression in ordering service locators by priority (longwave)
 * bug #57553 [HttpKernel] Enable optional cache-warmers when cache-dir != build-dir (nicolas-grekas)
 * bug #57497 [String] Fixed u()->snake(), b()->snake() and s()->snake() methods (arczinosek)
 * bug #57574 [Filesystem] Fix Filesystem::remove() on Windows (nicolas-grekas)
 * bug #57572 [DoctrineBridge] Fix compat with DI >= 6.4 (nicolas-grekas)
 * bug #57538 [String] Add `alias` case to `EnglishInflector` (alexandre-daubois)
 * bug #57533 [FrameworkBundle] Throw runtime exception when trying to use asset-mapper while http-client is disabled (nicolas-grekas)
 * bug #57520 [SecurityBundle] Remove unused memory users’ `name` attribute from the XSD (MatTheCat)
 * feature #57557 Ibexa is sponsoring Symfony 5.4, thanks to them! \o/ (nicolas-grekas)
 * bug #57569 [HttpClient][Mailer] Revert "Let curl handle transfer encoding", use HTTP/1.1 for Mailgun (nicolas-grekas)
 * bug #57499 [Mailer] Add additional headers in Scaleway bridge (MrMicky-FR)
 * bug #57460 [VarExporter] fix contravariance problem with __unserialize() in lazy proxy (nikophil)
 * bug #57397 [VarDumper] Fix FFI caster test (alexandre-daubois)
 * bug #57453 [HttpClient] Fix parsing SSE (fancyweb)
 * bug #57467 [SecurityBundle] Add `provider` XML attribute to the authenticators it’s missing from (MatTheCat)
 * bug #57384 [Notifier] Fix thread key in GoogleChat bridge (romain-jacquart)
 * bug #57372 [HttpKernel][Security] Fix accessing session for stateless request (VincentLanglet)
 * bug #57112 [Messenger] Handle `AMQPConnectionException` when publishing a message (jwage)
 * bug #57341 [Serializer] properly handle invalid data for false/true types (xabbuh)
 * bug #57187 [Serializer] Fix `ObjectNormalizer` with property path (HypeMC)
 * bug #57355 [ErrorHandler] Fix rendered exception code highlighting on PHP 8.3 (tscni)
 * bug #57310 [DependencyInjection] Fix ternary in `AutowireCallable` attribute (alamirault)
 * bug #57273 [FrameworkBundle] Fix setting default context for certain normalizers (HypeMC)
 * bug #57395 [Notifier]  send the recipient phone number as an array (xabbuh)
 * bug #52699 [Serializer] [PropertyAccessor] Ignore non-collection interface generics (mtarld)
 * bug #54634 [String] Fix #54611 pluralization of -on ending words + singularization of -a ending foreign words (Geordie, DesLynx)
 * bug #57213 [Validator] [UniqueValidator] Use correct variable as parameter in (custom) error message (seho-nl, Sebastien Hoek)
 * bug #54920 [Messenger] Comply with Amazon SQS requirements for message body (VincentLanglet)
 * bug #57321 [AssetMapper] fix npm version constraint conversion (Jean-Beru)
 * bug #57110 [PhpUnitBridge] Fix error handler triggered outside of tests (HypeMC)
 * bug #57297 [FrameworkBundle] not registered definitions must not be modified (xabbuh)
 * bug #57234 [String] Fix Inflector for 'hardware' (podhy)
 * bug #57224 [Mime] Use streams instead of loading raw message generator into memory (bytestream)

* 7.0.8 (2024-06-02)

 * bug #57284 [Mime] Fix TextPart using an unknown File (fabpot)
 * bug #57282 [Scheduler] Throw an exception when no dispatcher has been passed to a Schedule (fabpot)
 * bug #57275 Fix autoload configs to avoid warnings when building optimized autoloaders (Seldaek)
 * bug #54572 [Mailer] Fix sendmail transport failure handling and interactive mode (bobvandevijver)
 * bug #57228 [Mime] fix PHP 7 compatibility (xabbuh)
 * bug #57065 [Mime] Fixed `Mime\Message::ensureValidity()` when a required header is set, but has an empty body (rhertogh)
 * bug #57069 [Config] gracefully handle cases when no resolver is set (xabbuh)
 * bug #57109 [Notifier] keep boolean options when their value is false (xabbuh)
 * bug #54971 [Serializer] Cache readability/writability computation (mtarld)
 * bug #56488 [VarExporter] Fix exporting default values involving global constants (kylekatarnls)
 * bug #49186 [Serializer] Improve exception message in UnwrappingDenormalizer (andersonamuller)
 * bug #54694 [PropertyInfo] Update DoctrineExtractor for new DBAL 4 BIGINT type (llupa)
 * bug #54913 [Serializer] Fix CurrentType for missing property (ElisDN)
 * bug #54797 [PhpUnitBridge] Fix `DeprecationErrorHandler` with PhpUnit 10 (HypeMC)
 * bug #54878 [Filesystem] Fix dumpFile `stat failed` error hitting custom handler (acoulton)
 * bug #54924 [Validator] IBAN Check digits should always between 2 and 98 (karstennilsen)
 * bug #54919 [ErrorHandler] Do not call xdebug_get_function_stack() with xdebug >= 3.0 when not in develop mode (fmata)
 * bug #54910 [HttpFoundation]  filter out empty HTTP header parts (xabbuh)
 * bug #54888 [String] Fix folded in compat mode (smnandre)
 * bug #54863 [Process] Return `false` when `open_basedir` prevents access to `/dev/tty` (mjauvin)
 * bug #54860 [HttpClient] Revert fixing curl default options (alexandre-daubois)
 * bug #54850 [VarExporter] fix `ProxyHelper::generateLazyProxy()` when a method returns null (nikophil)
 * bug #54842 [Messenger] Don't drop stamps when message validation fails (valtzu)
 * bug #54838 [WebProfilerBundle] Fix assignment to constant variable (HypeMC)
 * bug #54837 [Mailer] [Sendgrid] Use `DataPart::getContentId()` when `DataPart::setContentId()` is used (SherinBloemendaal)
 * bug #54839 Fix exception thrown during `LDAP_MODIFY_BATCH_REMOVE_ALL` batch operations (phasdev)
 * bug #54834 [Validator] Check `Locale` class existence before using it (alexandre-daubois)
 * bug #54830 [HttpClient] Fix cURL default options for PHP 8.4 (alexandre-daubois)
 * bug #54828 [Serializer] Fix `GetSetMethodNormalizer` not working with setters with optional args (HypeMC)
 * bug #54816 [Cache] Fix support for predis/predis:^2.0 (mfettig)
 * bug #54804 [Serializer] separate the property info and write info extractors (xabbuh)
 * bug #54800 [WebProfilerBundle] fix compatibility with Twig 3.10 (xabbuh)
 * bug #54794 [Strings][EnglishInflector] Fix incorrect pluralisation of 'Album' (timporter)
 * bug #54714 [Serializer] convert empty CSV header names into numeric keys (xabbuh)
 * bug #54775 [Messenger] accept AbstractAsset instances when filtering schemas (xabbuh)
 * bug #54758 [Validator] handle edge cases when constructing constraints with named arguments (xabbuh)
 * bug #54759 [Filesystem] better distinguish URL schemes and Windows drive letters (xabbuh)
 * bug #54791 [FrameworkBundle] move wiring of the property info extractor to the ObjectNormalizer (xabbuh)
 * bug #54760 [Validator] handle union and intersection types for cascaded validations (xabbuh)
 * bug #54776 [Cache] fix: remove unwanted cast to int (Arend Hummeling)
 * bug #54700 [Dotenv] show overridden vars too when running debug:dotenv (HMRDevil)

* 7.0.7 (2024-04-29)

 * bug #54699 [DoctrineBridge] Update AbstractSchemaListener to adjust more database params (ywisax)
 * bug #54691 [Finder] Also consider .git inside the basedir of in() directory (nickvergessen)
 * bug #54724 [AssetMapper] Check asset/vendor directory is writable (smnandre)
 * bug #54750 [Validator] detect wrong usages of minMessage/maxMessage in options (xabbuh)
 * bug #54751 [Validator]  detect wrong e-mail validation modes (xabbuh)
 * bug #54723 [Form] read form values using the chain data accessor (xabbuh)
 * bug #54706 [Yaml] call substr() with integer offsets (xabbuh)
 * bug #54675 [PropertyInfo] Fix PHPStan properties type in trait (mtarld)
 * bug #54673 [Messenger] explicitly cast boolean SSL stream options (xabbuh)
 * bug #54665 Add test for AccessTokenHeaderRegex and adjust regex (Spomky)
 * bug #54635 [Serializer] Revert "Fix object normalizer when properties has the same name as their accessor" - it was a BC Break (NeilPeyssard)
 * bug #54625 [Intl] Remove resources data from classmap generation (shyim)
 * bug #54598 [TwigBridge]  implement NodeVisitorInterface instead of extending AbstractNodeVisitor (xabbuh)
 * bug #54072 [HttpKernel] Fix datacollector caster for reference object property (ebuildy)
 * bug #54395 [Serializer] Fixing PHP warning in the ObjectNormalizer with MaxDepth enabled (jaydiablo)
 * bug #54564 [Translation] Skip state=needs-translation entries only when source == target (nicolas-grekas)
 * bug #54579 [Cache] Always select database for persistent redis connections (uncaught)
 * bug #54059 [Security] Validate that CSRF token in form login is string similar to username/password (glaubinix)
 * bug #54530 [Clock] initialize the current time with midnight before modifying the date (xabbuh)
 * bug #54547 [HttpKernel] Force non lazy controller services (smnandre)
 * bug #54517 [HttpClient] Let curl handle transfer encoding (michaelhue)
 * bug #52917 [Serializer] Fix unexpected allowed attributes (mtarld)
 * bug #54063 [FrameworkBundle] Fix registration of the bundle path to translation (FlyingDR)
 * bug #54392 [Messenger] Make Doctrine connection ignore unrelated tables on setup (MatTheCat)
 * bug #54513 [HtmlSanitizer] Ignore Processing Instructions (smnandre)
 * bug #54506 [HttpFoundation] Set content-type header in RedirectResponse (smnandre)
 * bug #54505 [Serializer]  initialize serializer in trait with null (xabbuh)
 * bug #52698 [Serializer] Fix XML scalar to object denormalization (mtarld)
 * bug #54485 [Serializer] Ignore when using #[Ignore] on a non-accessor (nicolas-grekas)
 * bug #54105 [Messenger] Improve deadlock handling on `ack()` and `reject()` (jwage)
 * bug #54242 [HttpClient] [EventSourceHttpClient] Fix consuming SSEs with \r\n separator (fancyweb)
 * bug #54487 [Validator] Accept `Stringable` in `ExecutionContext::build/addViolation()` (alexandre-daubois)
 * bug #54456 [DomCrawler] Encode html entities only if nessecary (ausi)
 * bug #54484 [Serializer] reset backed_enum priority, and re-prioritise translatable (GwendolenLynch)
 * bug #54471 [Filesystem] Strengthen the check of file permissions in `dumpFile` (alexandre-daubois)
 * bug #54403 [FrameworkBundle] [Command] Fix #54402: Suppress PHP warning when is_readable() tries to access dirs outside of open_basedir restrictions (Jeldrik Geraedts)
 * bug #54440 [Console] return null when message with name is not set (xabbuh)
 * bug #54468 [Translation] Fix LocaleSwitcher throws when intl not loaded (smnandre)

* 7.0.6 (2024-04-03)

 * bug #54400 [HttpClient] stop all server processes after tests have run (xabbuh)
 * bug #54435 [Console] respect multi-byte characters when rendering vertical-style tables (xabbuh)
 * bug #54419 Fix TypeError on ProgressBar (Fan2Shrek)
 * bug #54425 [TwigBridge] Remove whitespaces from block form_help output (rosier)
 * bug #53969 [Mailer] include message id provided by the MTA when dispatching the `SentMessageEvent` (xabbuh)
 * bug #54315 [Serializer] Fixed BackedEnumNormalizer priority for translatable enum (IndraGunawan)
 * bug #54372 [Config] Fix `YamlReferenceDumper` handling of array examples (MatTheCat)
 * bug #54362 [Filesystem] preserve the file modification time when mirroring directories (xabbuh)
 * bug #54333 [HttpFoundation] Allow array style callable setting for Request setFactory method (simbera)
 * bug #54121 [Messenger] Catch TableNotFoundException in MySQL delete (acbramley)
 * bug #54271 [DoctrineBridge] Fix deprecation warning with ORM 3 when guessing field lengths (eltharin)
 * bug #54306 Throw TransformationFailedException when there is a null bytes injection (sormes)
 * bug #54148 [Serializer] Fix object normalizer when properties has the same name as their accessor (NeilPeyssard)
 * bug #54305 [Cache][Lock] Identify missing table in pgsql correctly and address failing integration tests (arifszn)
 * bug #54199 [Mailer] [Brevo] Check that tags is present in payload before calling setTags (palgalik)
 * bug #54292 [FrameworkBundle] Fix mailer config with XML (lyrixx)
 * bug #54298 [Filesystem] Fix str_contains deprecation (NeilPeyssard)
 * bug #54248 [Security] Correctly initialize the voter property (aschempp)
 * bug #54273 [DependencyInjection] fix XmlDumper when a tag contains also a 'name' property (lyrixx)
 * bug #54191 [Validator] add missing invalid extension error entry (xabbuh)
 * bug #54194 [PropertyAccess] Fix checking for missing properties (nicolas-grekas)
 * bug #54201 [Lock] Check the correct SQLSTATE error code for MySQL (edomato)
 * bug #54252 [Lock] compatiblity with redis cluster 7 (bastnic)
 * bug #54265 [VarDumper] prevent error in value to Typed property must not be accessed before initialization (shakaran)
 * bug #54124 [Messenger] trigger retry logic when message is a redelivery (nikophil)
 * bug #54254 [HttpKernel] Fix creating `ReflectionMethod` with only one argument (alexandre-daubois)
 * bug #54219 [Validator] Allow BICs’ first four characters to be digits (MatTheCat)
 * bug #54239 [Mailer] Fix sendmail transport not handling failure  (aboks)
 * bug #54207 [HttpClient] Lazily initialize CurlClientState (arjenm)
 * bug #53865 [Workflow]Fix Marking when it must contains more than one tokens (lyrixx)
 * bug #54137 [Validator] UniqueValidator - normalize before reducing keys (Brajk19)
 * bug #54187 [FrameworkBundle] Fix PHP 8.4 deprecation on `ReflectionMethod` (alexandre-daubois)
 * bug #54167 [Messenger] [Amqp] Handle AMQPConnectionException when publishing a message. (jwage)
 * bug #54146 [HttpClient] Preserve float in JsonMockResponse (Jibbarth)

* 7.0.5 (2024-03-04)

 * bug #54113 [AssetMapper] Throw exception in Javascript compiler when PCRE error (smnandre)
 * bug #54129 [Clock] Add attributes to support PHPUnit 10 + 11 (ruudk)
 * bug #54079 [AssetMapper] Fix `JavaScriptImportPathCompiler` regression in regex (PhilETaylor)
 * bug #54102 [HttpClient] Fix deprecation on PHP 8.3 (nicolas-grekas)
 * bug #54089 [Mailer] [Brevo] Remove tags from mandatory event arguments (palgalik)
 * bug #54081 [DoctrineBridge] Safeguard dynamic access to Doctrine metadata properties (derrabus)
 * bug #54080 [Routing] Enhance error handling in StaticPrefixCollection for compatibility with libpcre2-10.43 (Lustmored)

* 7.0.4 (2024-02-27)

 * bug #53985 [HttpKernel] Allow tagged controllers in ControllerResolver (marein)
 * bug #54054 [VarExporter] Bugfix/workaround jit issue (verfriemelt-dot-org)
 * bug #54050 [Messenger] Revert "Resend failed retries back to failure transport " (ro0NL)
 * bug #54045 [Config][Messenger][Security] Don't turn deprecations into exceptions  when unserializing (nicolas-grekas)
 * bug #54035 [DependencyInjection] Fix computing error messages involving service locators (nicolas-grekas)
 * bug #53959 [Serializer] Fix unknown types normalization type when know type (Myks92)
 * bug #53960 [Messenger] the 'use_notify' option is on the factory, not on the postgres connection (dbu)
 * bug #54031 [ErrorHandler] Fix parsing messages that contain anonymous classes on PHP >= 8.3.3 (nicolas-grekas)
 * bug #54014 [AssetMapper] Fix enquoted string pattern (smnandre)
 * bug #54010 [Translation] Fix extracting qualified `t()` function calls (rvanvelzen)
 * bug #53967 [ErrorHandler] return the unchanged text if preg_replace_callback() fails (xabbuh)
 * bug #54009 [Console] Fix display of vertical Table on Windows OS (VincentLanglet)
 * bug #54001 [Console] Fix display of Table on Windows OS  (VincentLanglet)
 * bug #53989 [FrameworkBundle] Fix config builder with extensions extended in `build()` (HypeMC)
 * bug #54005 Fix a minor design issue in the Welcome Page (javiereguiluz)
 * bug #54004 [WebProfilerBundle] disable turbo in web profiler toolbar to avoid link prefetching (davidgorges)
 * bug #54006 [Process] Fix the `command -v` exception (kayw-geek)
 * bug #53975 [Cache] explicitly cast boolean SSL stream options (xabbuh)
 * bug #53926 [TwigBridge] foundation 5 layout: use form_label_content block for checkbox and radio labels (wetternest)
 * bug #53913 [TwigBridge] Fix compat with Twig v3.9 (nicolas-grekas)
 * bug #53819 [Doctrine Messenger] Fix support for pgsql + pgbouncer. (jwage)
 * bug #53944 [Messenger] Gracefully fallback to empty queue config (Wirone)
 * bug #53935 [Mailer] [Mailgun] Fix expecting payload without tags or user variables (norkunas)
 * bug #53934 [Mailer] Fix signed emails breaking the profiler (HypeMC)
 * bug #53924 [FrameworkBundle] Check if the _route attribute exists on the request (xvilo)
 * bug #53910 [Messenger] Fix SQS visibility_timeout type (valtzu)
 * bug #53891 [PropertyAccess] Fixes getValue() on an unitialized object property on a lazy ghost (priyadi)
 * bug #53889 [HttpClient] Make retry strategy work again (Nyholm)
 * bug #53906 [VarDumper] Fix serialization of stubs with null or uninitialized values (derrabus)
 * bug #53890 [VarExporter] Uniform unitialized property error message under ghost and non-ghost objects (priyadi)
 * bug #53893 [AssetMapper] Ignore comment lines in JavaScriptImportPathCompiler (smnandre)
 * bug #53826 [DomCrawler][Form] Fix the exclusion of <template> (mpiot)
 * bug #53869 [Mailer][Postmark][Webhook] Fix webhook testing in dockerized setups (aleho)
 * bug #53755 [Validator] Fix fields without constraints in `Collection` (xabbuh, HypeMC)
 * bug #53821 [Process] Fix Inconsistent Exit Status in proc_get_status for PHP Versions Below 8.3 (Luc45)
 * bug #53829 [Mailer][Postmark][Webhook] Accept different date formats (aleho)
 * bug #53870 [Dotenv] Specify envKey while loading variables with the dotenv:dump (scruwi)
 * bug #53876 [DependencyInjection] fix unable to make lazy service from readonly class (kor3k)
 * bug #53733 [HttpFoundation] Prevent duplicated headers when using Early Hints (dunglas)
 * bug #53817 [Scheduler] Fix messenger receiver with no alias (HypeMC)
 * bug #53842 [VarDumper] Fix configuring CliDumper with SYMFONY_IDE env var (nicolas-grekas)
 * bug #53824 [Mailer][Postmark][Webhook] Don't require tag and metadata (aleho)
 * bug #53846 [Cache] Fix BC layer with pre-6.1 cache items (nicolas-grekas)
 * bug #53792 [FrameworkBundle] Fix eager-loading of env vars in ConfigBuilderCacheWarmer (nicolas-grekas)
 * bug #53785 [FrameworkBundle] Prevent silenced warning by checking if /proc/mount exists (shyim)
 * bug #53730 [Messenger] [Beanstalkd] fix tube stats when it's empty (eminjk)
 * bug #53754 [DoctrineBridge] forward-compatibility with field mappings in Doctrine ORM 4 (xabbuh)
 * bug #53751 [AssetMapper] Improve import_polyfill configuration error (smnandre)
 * bug #53704 Fix client side connection timeout breaks mail authentication (bytestream)
 * bug #53744 [SecurityBundle] add missing partition attribute to the schema definition (xabbuh)
 * bug #53707 [Console] Fix color support for TTY output (theofidry)
 * bug #53712 [Mailer] Fix usage of stream_set_timeout in case of microseconds (aleksejs1)
 * bug #53715 [String] Fix plural of word ending by pus (Fan2Shrek)
 * bug #53711 [Console] Allow false as a $shortcut in InputOption (jayminsilicon)
 * bug #53716 [Mailer] [Mailgun] Fix payload converter getReason (norkunas)
 * bug #53703 [HttpFoundation] Fix clearing CHIPS cookies (misaert)
 * bug #53701  [AssetMapper] Fix exception if assets directory is missing in production (rynhndrcksn)
 * bug #53652 [AssetMapper] Fix JavaScript compiler load imports from JS strings (smnandre)
 * bug #53689 [HttpKernel] Fix including welcome page multiple times (HypeMC)

* 7.0.3 (2024-01-31)

 * bug #52913 [Routing] Fixed priority getting lost when setting localized prefix (pritasil)
 * bug #53681 [DoctrineBridge]  Fix detection of Xml/Yaml driver in DoctrineExtension (GromNaN)
 * bug #53183 [Messenger] PhpSerializer: TypeError should throw `MessageDecodingFailedException` (B-Galati)
 * bug #52131 [HttpKernel] Fix `RequestPayloadValueResolver` handling error with no ExpectedTypes (Jeroeny)
 * bug #51559 [DependencyInjection] `#[Autowire]` attribute should have precedence over bindings (HypeMC)
 * bug #53678 [Mime] Fix serializing uninitialized `RawMessage::$message` to null (nicolas-grekas)
 * bug #53634 [Notifer][Smsapi] Set messageId of SentMessage (tomasz-kusy)
 * bug #53501 [DependencyInjection] support lazy evaluated exception messages with Xdebug 3 (xabbuh)
 * bug #53672 [FrameworkBundle] `ConfigBuilderCacheWarmer` should be non-optional (nicolas-grekas)
 * bug #52994 [MonologBridge] Fix context data and display extra data (louismariegaborit)
 * bug #53671 [HttpClient] Fix pausing responses before they start when using curl (nicolas-grekas)
 * bug #53594 [Notifier] Updated the NTFY notifier to run without a user parameter (lostfocus)
 * bug #53620 [Validator] Fix option filenameMaxLength to the File constraint (Image) (mindaugasvcs)
 * bug #53624 [Translation] Fix constant domain resolution in PhpAstExtractor (VincentLanglet)
 * bug #53663 [TwigBridge] separate child and parent context in NotificationEmail on writes (xabbuh)
 * bug #53667 [Mailer] [Mailgun] Fix sender header encoding (spajxo)
 * bug #53631 [DependencyInjection] Fix loading all env vars from secrets when only a subset is needed (nicolas-grekas)
 * bug #53656 [Form] Use self-closing `<input />` syntax again, reverting #47715 (mpdude)
 * bug #53653 [Mailer] [Scaleway] Fix attachment handling (madbob)
 * bug #53157 [Mailer] Throw `TransportException` when unable to read from socket (xdanik)
 * bug #53361 [Serializer] Take unnamed variadic parameters into account when denormalizing (thijsBreker)
 * bug #53530 [Serializer] Rewrite `AbstractObjectNormalizer::createChildContext()` to use the provided `cache_key` from original context when creating child contexts (amne)
 * bug #53506 [HttpClient] Fix error chunk creation in passthru (rmikalkenas)
 * bug #53260 [AssetMapper] Handle assets with non-ascii characters in dev server (fbourigault)
 * bug #53357 [Translation] Fix `TranslationNodeVisitor` with constant domain (VincentLanglet)
 * bug #53525 [Messenger] [AMQP] Throw exception on `nack` callback (kvrushifa)
 * bug #53432 [HttpFoundation] Request without content-type or content-length header should result in null values, not empty strings (priyadi)
 * bug #53593 [Cache] Fix possible infinite loop in `CachePoolPass` (HypeMC)
 * bug #53588 [Translation] fix multi-byte code area to convert (xabbuh)
 * bug #53572 [FrameworkBundle] grab a service from the container only if it exists (xabbuh)
 * bug #53565 [Mime] Fix undefined array key 0 when empty sender (0x346e3730)
 * bug #53516 [Console] Allow '0' as a $shortcut in InputOption.php (lawsonjl-ornl)
 * bug #53576 [Console] Only execute additional checks for color support if the output (theofidry)
 * bug #53582 [TwigBundle] Fix configuration when "paths" is null (smnandre)
 * bug #53575 [Mailer] register the MailPaceTransportFactory (xabbuh)
 * bug #53581 [String] fix aircraft inflection (renanbr)
 * bug #53509 [Security] Fix `AuthenticationUtils::getLastUsername()` returning null (alexandre-daubois)
 * bug #53529 [Ldap] Use `{user_identifier}` over deprecated `{username}` in factories (tcitworld)
 * bug #53567 [String] Correct inflection of axis (Vladislav Iurciuc)
 * bug #53537  [VarDumper] Fix missing colors initialization in `CliDumper` (nicolas-grekas)
 * bug #53521 [VarDumper] Fixes `Typed property Symfony\Component\VarDumper\Dumper\CliDumper::$colors must not be accessed before initialization` (crynobone)
 * bug #53481 [Process] Fix executable finder when the command starts with a dash (kayw-geek)
 * bug #53006 [ErrorHandler] Don't format binary strings (aleho)
 * bug #53453 [Translation] add support for nikic/php-parser 5.0 (xabbuh)
 * bug #53434 [ErrorHandler] fix rendering exception pages without the HttpKernel component (xabbuh)
 * bug #53441 [Messenger] Amazon SQS Delay has a max of 15 minutes (alamirault)
 * bug #53414 [Serializer] `GetSetMethodNormalizer`: fix BC break with `#[Ignore]` attribute  (nikophil)
 * bug #53383 [Validator] re-allow an empty list of fields (xabbuh)
 * bug #53418 [FrameworkBundle][Notifier] Fix service registration (MessageBird + TurboSms) (smnandre)
 * bug #53381 [Form] Fix assigning data in `PostSetDataEvent` and `PostSubmitEvent` (fancyweb)
 * bug #53350 [Validator] fix the exception being thrown (xabbuh)
 * bug #52930 [Messenger] Fix Redis messenger scheme comparison (freswa)
 * bug #52874 [Scheduler] Separate id and description in message providers (valtzu)
 * bug #53341 [FrameworkBundle] append instead of replacing potentially non-existent named-arguments (xabbuh)
 * bug #53320 [Cache][DependencyInjection][Lock][Mailer][Messenger][Notifier][Translation] Url decode username and passwords from `parse_url()` results (alexandre-daubois)
 * bug #53108 [Serializer] Fix using deserialization path 5.4 (HypeMC)

* 7.0.2 (2023-12-30)

 * bug #53282 [RateLimiter] Fix RateLimit->getRetryAfter() return value when consuming 0 or last tokens (wouterj, ERuban)
 * bug #53054 [Cache] Fix expiration time for CouchbaseCollection (alexandre-daubois)
 * bug #53259 [RateLimit] Test and fix peeking behavior on rate limit policies (wouterj)
 * bug #52406 [Validator] Fix `Constraints\Email::ERROR_NAMES` (mathroc)
 * bug #53140 [Serializer] Skip uninitialized properties with deep_object_to_populate (mtarld)
 * bug #53195 [HttpKernel] Fix default locale is ignored when `set_locale_from_accept_language` is used (jkobus)
 * bug #52928 [Dotenv] Allow environment variables starting with an underscore (xabbuh)
 * bug #53243 [Mailer][Postmark] Add missing changelog for webhook support (OskarStark)
 * bug #53239 [HttpKernel] fix "Cannot redeclare renderSymfonyLogoSvg()" inside phpunit tests (davidesigner)
 * bug #53232 [Notifier] [Smsc] Require login and password (OskarStark)
 * bug #53225 [WebProfilerBundle] Fix the design of the compact toolbar button (javiereguiluz)
 * bug #52869 [AssetMapper] Improve link generation script (smnandre)
 * bug #53203 [Intl] [Emoji] Fix emoji files (remove wrong characters / add missing data) (smnandre)
 * bug #53178 [Translation][Crowdin] Use project language mapping (andrii-bodnar)
 * bug #53187 [Messenger] Fix using negative delay (J-roen)
 * bug #53133 [Validator] Fix using known option names as field names (HypeMC)
 * bug #53172 [SecurityBundle] Prevent to login/logout without a request context (symfonyaml)
 * bug #52881 [DoctrineBridge] Global query time always at 0.00 ms on profiler (Maxime THIRY)
 * bug #53173 [FrameworkBundle] add missing webhook services for Brevo and Mailjet (xabbuh)
 * bug #53153 [WebProfilerBundle] Fix JS error when evaluating scripts (jderusse)
 * feature #53150 [Contracts] Allow psr/container 1.1 again (derrabus)
 * bug #52998 [Notifier] [Bridges] Provide EventDispatcher and HttpClient to the transport (rdavaillaud)
 * bug #52817 [Serializer] Do not instantiate object if it is not instantiable (maxbaldanza)
 * bug #53003 [AssetMapper] Fix URL pattern when importing es-module-shims (hashbanged)
 * bug #53079 [DoctrineBridge] Add check for lazy object interface (maxbaldanza)
 * bug #53061 [Mailer] [Mailjet] Disable tls for mailjet as it should use STARTTLS (RFreij)
 * bug #53115 [Serializer] Fix partial denormalization with missing constructor arguments (HypeMC)
 * bug #53128 Change ProxyCacheWarmer::warmUp signature (llupa)
 * bug #53120 [Translation] add the Phrase translation provider to the UnsupportedSchemeException (xabbuh)
 * bug #53125 [Mailer] add the MailPace transport to the UnsupportedSchemeException (xabbuh)
 * bug #53081 [Serializer] Keep stack trace for enum value denormalizer error (kylekatarnls)
 * bug #53107 [HttpKernel] Don't validate partially denormalized object (HypeMC)
 * bug #52891 [HttpKernel] Fix request attribute value ignored with pinned resolvers (HypeMC)
 * bug #53057 [HttpKernel] Move ``@internal`` from `AbstractSessionListener` class to its methods and properties (Florian-Merle)
 * bug #52990 [TwigBridge] don't use deprecated and internal Twig functions (xabbuh)
 * bug #53004 [FrameworkBundle] Add missing webhook parsers (alexandre-daubois)
 * bug #53007 [FrameworkBundle] Fix webhook parser service removal and add notifier parser service removal (alexandre-daubois)
 * bug #52996 [Validator] add missing translation (xabbuh)
 * bug #52979 [WebProfilerBundle] Fix "Copy as cURL" dark style (HypeMC)
 * bug #52978 [Webhook] [Framework] Added missing XML attribute in config XSD (TimoBakx)
 * bug #52584 [WebProfilerBundle] Fix intercept external redirects (HeahDude)
 * bug #52964 [ExpressionLanguage] Fix null coalescing propagation (fancyweb)
 * bug #52963 [FrameworkBundle] Fix profiling commands without router (HeahDude)
 * bug #52966 [FrameworkBundle] Fix profiling command in web context (HeahDude)
 * bug #52937 [WebProfilerBundle] Fix "Copy as cURL" (HypeMC)
 * bug #52940 [Console] Fix color support check on non-Windows platforms (theofidry)
 * bug #52896 [Messenger] Avoid reconnecting active Redis connections. (BusterNeece)
 * bug #52923 Avoid incompatibility with symfony/console 7 (jdecool)
 * bug #52927 [Dotenv] Properly handle `SYMFONY_DOTENV_VARS` being the empty string (xabbuh)
 * bug #52935 [Validator] Missing translations for Slovak (sk) #51954 (Jan Vernarsky)
 * bug #52941 [Console] Fix xterm detection (theofidry)
 * bug #52795 [FrameworkBundle]  do not overwrite an application's default serialization context (xabbuh)
 * bug #52870 [SecurityBundle] Fix redeclaration of `InternalSecurity` class when opcache preload is active (kaznovac)
 * bug #52885 [Serializer] fix nullable int cannot be serialized (nikophil)
 * bug #52886 [HttpKernel] Catch `TypeError` if the wrong type is used in `BackedEnumValueResolver` (alexandre-daubois)
 * bug #52878 [WebProfiler] Fix unclosed JS script cannot be parsed  (smnandre)
 * bug #52867 [Validator] Only trigger deprecation when Validator annotations are used (HypeMC)
 * bug #52864 [HttpClient][Mailer][Process] always pass microseconds to usleep as integers (xabbuh)

* 7.0.1 (2023-12-01)

 * bug #52814 [Workflow] Add `getEnabledTransition()` to TraceableWorkflow (alexandre-daubois)
 * bug #52852 [Serializer] Fix TranslatableNormalizer when the Translator is disabled (Jean-Beru)
 * bug #52836 [DependencyInjection] Fix parsing named autowiring aliases that contain underscores (nicolas-grekas)
 * bug #52804 [Serializer] Fix support of plain object types denormalization (andersonamuller)
 * bug #52845 [Routing] Restore aliases removal in RouteCollection::remove() (fancyweb)
 * bug #52846 [PhpUnitBridge]  run composer update for compatibility with PHPUnit versions shipping composer.lock (xabbuh)
 * bug #52823 add parameter types in query builder (javiercno)
 * bug #52825 [AssetMapper] Upgrade asset mapper to 6.4 fails due to invalid entries "downloaded_to" and "preload" (redflo)
 * bug #52808 [DependencyInjection] Fix dumping containers with null-referenced services (nicolas-grekas)
 * bug #52797 [VarExporter] Fix lazy ghost trait when using nullsafe operator (nicolas-grekas)
 * bug #52806 [Routing] Fix removing aliases pointing to removed route in `RouteCollection::remove()` (fancyweb)
 * bug #52805 [Routing] Fix conflicting FQCN aliases with route name (fancyweb)

* 7.0.0 (2023-11-29)

 * bug #52786 [Serializer] Revert allowed attributes fix (mtarld)
 * bug #52765 [Translation] Remove ``@internal`` from abstract testcases (OskarStark)
 * bug #52780 [DependencyInjection] don't check parameter values if they are not set (xabbuh)
 * bug #52762 [VarExporter] Work around php/php-src#12695 for lazy objects, fixing nullsafe-related behavior (nicolas-grekas)
 * bug #52759 [VarExporter] Fix serializing objects that implement __sleep() and that are made lazy (nicolas-grekas)
 * bug #52767 [Serializer] Fix normalization relying on allowed attributes only (mtarld)
 * bug #52727 [String] Fix Inflector for 'icon' (podhy)

* 7.0.0-RC2 (2023-11-26)

 * bug #52724 [Security] make secret required for DefaultLoginRateLimiter (RobertMe)
 * feature #52720 [Cache] Remove database server version detection (derrabus)
 * bug #52617 [AssetMapper] Fix resolving jsdeliver default + other exports from modules (ogizanagi)
 * feature #52712 [AssetMapper] Exclude dot files (weaverryan)
 * bug #52725 [AssetMapper] Fix: also download files referenced by url() in CSS (weaverryan)
 * bug #52702 [AssetMapper] Fix eager imports are not deduplicated (smnandre)
 * bug #52719 [Mime] Add `TemplatedEmail::$locale` to the serialized props (mkrauser)
 * bug #52677 [Translation] [Lokalise] Fix language format on Lokalise Provider (welcoMattic)
 * bug #52715 [Cache] fix detecting the database server version (xabbuh)
 * bug #52688 [Cache] Add url decoding of password in `RedisTrait` DSN (alexandre-daubois)
 * bug #52172 [Serializer] Fix denormalizing empty string into `object|null` parameter (Jeroeny)
 * bug #52693 [Messenger] Fix message handlers with multiple `from_transports` (valtzu)
 * bug #52684 [PropertyInfo] Fixed promoted property type detection for `PhpStanExtractor` (LastDragon-ru)
 * bug #52681 [Serializer] Fix support for DiscriminatorMap in PropertyNormalizer (mtarld)
 * bug #52680 [Serializer] Fix access to private properties/getters when using the ``@Ignore`` annotation (mtarld)
 * bug #52713 [Serializer] Fix deserialization_path missing using contructor (mtarld)
 * bug #52683 [Serializer] Fix constructor deserialization path (mtarld)
 * bug #52707 [HttpKernel] Fix logging deprecations to the "php" channel when channel "deprecation" is not defined (nicolas-grekas)
 * bug #52589 [Serializer] Fix XML attributes not added on empty node (mtarld)
 * bug #52686 [Cache] fix detecting the server version with Doctrine DBAL 4 (xabbuh)
 * bug #51797 [MonologBridge] Fix error cannot use object of type as array (vtsykun)
 * bug #52629 [Messenger] Fix support for Redis Sentinel using php-redis 6.0.0 (pepeh)
 * bug #52656 [FrameworkBundle] Add TemplateController to the list of allowed controllers for fragments (nicolas-grekas)
 * bug #52459 [Cache][HttpFoundation][Lock] Fix PDO store not creating table + add tests (HypeMC)
 * bug #52626 [Serializer] Fix denormalizing date intervals having both weeks and days (oneNevan)
 * bug #52578 [Serializer] Fix denormalize constructor arguments (mtarld)
 * bug #52526 Add some more non-countable English nouns (paullallier)
 * bug #52604 [FrameworkBundle] register the virtual request stack together with common profiling services (xabbuh)
 * bug #52039 [Scheduler] Continue with stored `Checkpoint::$time` on lock (Jeroeny)
 * bug #52631 [DomCrawler] Revert "bug #52579 UriResolver support path with colons" (lyrixx)
 * bug #52606 [DoctrineBridge] Fix use "attribute" driver by default (vtsykun)
 * bug #52618 [VarExporter] Fix handling mangled property names returned by __sleep() (nicolas-grekas)

* 7.0.0-RC1 (2023-11-15)

 * bug #52597 [DependencyInjection] Fix dumping containers with null-referenced services (nicolas-grekas)
 * bug #52588 [Messenger] Use extension_loaded call to check if pcntl extension is loaded, as SIGTERM might be set be swoole (Sergii Dolgushev)
 * feature #52569 [VarExporter] Drop support for partially initialized lazy object (nicolas-grekas)
 * bug #52567 [AssetMapper] Fixing js sourceMappingURL extraction when sourceMappingURL used in code (weaverryan)
 * bug #52579 [DomCrawler] UriResolver support path with colons (vdauchy)
 * bug #52581 [Messenger] attach all required parameters to query (xabbuh)
 * feature #52568 [VarExporter] Deprecate per-property lazy-initializers (nicolas-grekas)
 * feature #52560 [Mailer] Update default Mailjet port (Katario)

* 7.0.0-BETA3 (2023-11-10)

 * bug #51666 [RateLimiter] CompoundLimiter was accepting requests even when some limiters already consumed all tokens (10n)
 * bug #52524 [AssetMapper] Only download a CSS file if it is explicitly advertised (weaverryan)
 * bug #52523 [AssetMapper] avoid caching MappedAsset inside JavaScript Import (weaverryan)
 * bug #52519 [AssetMapper] If assets are served from a subdirectory or CDN, also adjust importmap keys (weaverryan)
 * bug #52508 [AssetMapper] Fix jsdelivr import parsing with no imported value (weaverryan)
 * security #cve-2023-46734 [TwigBridge] Ensure CodeExtension's filters properly escape their input (nicolas-grekas, GromNaN)
 * security #cve-2023-46735 [Webhook] Remove user-submitted type from HTTP response (nicolas-grekas)
 * security #cve-2023-46733 [Security] Fix possible session fixation when only the *token* changes (RobertMe)
 * bug #52514 [FrameworkBundle] Don't reference SYMFONY_IDE env var in non-debug mode (nicolas-grekas)
 * bug #52506 [SecurityBundle] wire the secret for Symfony 6.4 compatibility (xabbuh)
 * bug #52496 [VarDumper] Accept mixed key on `DsPairStub` (marc-mabe)
 * bug #52502 [Config] Prefixing `FileExistenceResource::__toString()` to avoid conflict with `FileResource` (weaverryan)
 * bug #52491 [String] Method toByteString conversion using iconv is unreachable (Vincentv92)
 * bug #52488 [HttpKernel] Fix PHP deprecation (nicolas-grekas)
 * bug #52469 Check whether secrets are empty and mark them all as sensitive (nicolas-grekas)
 * feature #52471 [HttpKernel] Add `ControllerResolver::allowControllers()` to define which callables are legit controllers when the `_check_controller_is_allowed` request attribute is set (nicolas-grekas)
 * bug #52476 [Messenger] fix compatibility with Doctrine DBAL 4 (xabbuh)
 * bug #52434 [Console][FrameworkBundle] Fix missing `profile` option for console commands (keulinho)
 * bug #52474 [HttpFoundation] ensure string type with mbstring func overloading enabled (xabbuh)
 * bug #52472 [HttpClient][WebProfilerBundle] Do not generate cURL command when files are uploaded (MatTheCat)
 * bug #52457 [Cache][HttpFoundation][Lock] Fix empty username/password for PDO PostgreSQL (HypeMC)
 * bug #52443 [Yaml] Fix uid binary parsing (mRoca)
 * feature #52449 [TwigBridge] Mark CodeExtension as `@internal` (fabpot)
 * bug #52429 [HttpClient] Replace `escapeshellarg` to prevent overpassing `ARG_MAX` (alexandre-daubois)
 * bug #52442 Disable the "Copy as cURL" button when the debug info are disabled (stof)
 * bug #52444 Remove full DSNs from exception messages (nicolas-grekas)
 * bug #52438 [HttpKernel] Fix uninitialized property in Bundle class (javiereguiluz)
 * feature #52336 [HttpFoundation][Lock] Makes MongoDB adapters usable with `ext-mongodb` only (GromNaN)
 * bug #52428 [HttpKernel] Preventing error 500 when function putenv is disabled (ShaiMagal)
 * bug #52427 [Console][Process] do not let context classes extend the message classes (xabbuh)
 * bug #52408 [Yaml] Fix block scalar array parsing (NickSdot)
 * bug #52132 [Console] Fix horizontal table top border is incorrectly rendered (OskarStark)
 * bug #52368 [AssetMapper] Fixing bug where JSCompiler used non-absolute importmap entry path (weaverryan)
 * bug #52367 [Uid] Fix UuidV7 collisions within the same ms (nicolas-grekas)
 * bug #52287 [FrameworkBundle] Fix deprecation layer for "enable_annotations" in validation and serializer configuration (lyrixx)
 * bug #52222 [MonologBridge] Fix support for monolog 3.0 (louismariegaborit)

* 7.0.0-BETA2 (2023-10-29)

 * bug #52329 [HttpClient] Psr18Client: parse HTTP Reason Phrase for Response (Hanmac)
 * bug #52323 [AssetMapper] Allowing circular references in JavaScriptImportPathCompiler (weaverryan)
 * bug #52331 [AssetMapper] Fix file deleting errors & remove nullable MappedAsset on JS import (weaverryan)
 * bug #52332 [Yaml] Fix deprecated passing null to trim() (javaDeveloperKid)
 * bug #52349 [AssetMapper] Fix in-file imports to resolve via filesystem (weaverryan)
 * bug #52343 [Intl] Update the ICU data to 74.1 (jderusse)
 * bug #52347 [Form] Fix merging form data and files (ter) (Jan Pintr)
 * bug #52330 [AssetMapper] Fixing memory bug where we stored way more file content than needed (weaverryan)
 * bug #52325 [AssetMapper] jsdelivr "no version" import syntax (weaverryan)
 * bug #52307 [Scheduler] Save checkpoint in a finally block (FrancoisPog)
 * feature #52193 [PhpUnitBridge] Allow setting the locale using SYMFONY_PHPUNIT_LOCALE env var (VincentLanglet)
 * bug #52290 [DebugBundle] ignore a not-existing virtual request stack (xabbuh)
 * bug #52308 [SecurityBundle] Fix missing login-link element in xsd schema (fancyweb)
 * bug #51331 [Messenger] add handler description as array key to `HandlerFailedException::getWrappedExceptions()` (kbond)
 * bug #52298 [HttpKernel] Update AbstractBundle.php, use !isset($this->path) (tacman)
 * bug #51992 [Serializer] Fix using `DateIntervalNormalizer` with union types (Jeroeny)
 * bug #52276 DB table locks on messenger_messages with many failures (bn-jdcook)
 * bug #52232 [Messenger] declare constructor argument as optional for backwards compatibility (xabbuh)
 * bug #52254 [AssetMapper] Adding import-parsing case where import contains a path (weaverryan)
 * bug #52283 [Serializer] Handle default context when denormalizing timestamps in DateTimeNormalizer (mtarld)
 * bug #52272 [VarDump] Fix order of dumped properties - parent goes first (lyrixx)
 * bug #52274 [FrameworkBundle] re-introduce conflict rule with WebProfilerBundle < 6.4 (xabbuh)
 * bug #52268 [Mailer][Notifier] Update Sendinblue / Brevo API host (Stephanie)
 * bug #52255 [Form] Skip merging params & files if there are no files in the first place (dmaicher, priyadi)
 * bug #52234  add return type hints to EntityFactory (xabbuh)
 * bug #52229 [FrameworkBundle] Fix CommandDataCollector is always registered (smnandre)
 * bug #52218 [FrameworkBundle] Add conflict with `WebProfilerBundle` < 6.4 (HeahDude)

* 7.0.0-BETA1 (2023-10-21)

 * feature #51847 [AssetMapper] Allowing for files to be written to some non-local location (weaverryan)
 * feature #52079 [HttpKernel] Add parameters `kernel.runtime_mode` and `kernel.runtime_mode.*`, all set from env var `APP_RUNTIME_MODE` (nicolas-grekas)
 * feature #51348 [FrameworkBundle][Validator] Allow implementing validation groups provider outside DTOs (Yonel Ceruto)
 * feature #51577 [Notifier][Novu] Implement overrides (wouter-toppy)
 * feature #51211 [Workflow] List place and transition listeners in profiler (lyrixx)
 * feature #51220 [Workflow] Add a `TraceableWorkflow` (lyrixx)
 * feature #52120 [AssetMapper] Split ImportmapManager into 2 (weaverryan)
 * feature #51849 [AssetMapper] Warn of missing or incompat dependencies (weaverryan)
 * feature #52032 [FrameworkBundle][Routing][Translation][Workflow] Move some compiler passes from FrameworkBundle to components (fancyweb)
 * feature #52166 [HtmlSanitizer] Add support for sanitizing unlimited length of HTML document (lyrixx)
 * feature #48095 [Messenger] [Sqs] Add `AddFifoStamp` middleware (tyx)
 * feature #52160 [DoctrineBridge] Change argument `$lastUsed` of `DoctrineTokenProvider::updateToken()` to accept `DateTimeInterface` (nicolas-grekas)
 * feature #52140 [Translation] Add argument `$buildDir` to `DataCollectorTranslator::warmUp()` (nicolas-grekas)
 * feature #52047 [HttpFoundation][Runtime] Add $flush parameter to Response::send() (fancyweb)
 * feature #51470 [FrameworkBundle][Serializer] Deprecate annotations (alexandre-daubois)
 * feature #51483 [FrameworkBundle][Routing] Deprecate annotations (alexandre-daubois)
 * feature #47416 [Console][FrameworkBundle][HttpKernel][WebProfilerBundle] Enable profiling commands (HeahDude)
 * feature #50391 [FrameworkBundle][HttpKernel] Introduce `$buildDir` argument to `WarmableInterface::warmup` to warm read-only artefacts in `build_dir` (Okhoshi)
 * feature #52087 [Scheduler] Add `FailureEvent` (alli83)
 * feature #51828 [AssetMapper] Put importmap in polyfill so it can be hosted locally easily (weaverryan)
 * feature #52024 [AssetMapper] Add a "package specifier" to importmap in case import name != package+path (weaverryan)
 * feature #50734 [ErrorHandler] Improve fileLinkFormat handling (nlemoine)
 * feature #52002 [HttpFoundation] Cookies Having Independent Partitioned State (CHIPS) (fabricecw)
 * feature #51805 [Scheduler] pre_run and post_run events (alli83)
 * feature #51926 [Mime] Forbid messages that are generators to be used more than once (fabpot)
 * feature #50946 [Routing][SecurityBundle] Add `LogoutRouteLoader` (MatTheCat)
 * feature #52038 [Console] Dispatch `ConsoleTerminateEvent` when exiting on signal (HeahDude)
 * feature #49893 [Serializer] Add `XmlEncoder::CDATA_WRAPPING` context option (AndoniLarz)
 * feature #50877 [Finder] Add early directory prunning filter support (mvorisek)
 * feature #51829 [AssetMapper] Automatically preload CSS files if WebLink available (weaverryan)
 * feature #51011 [FrameworkBundle] Add parameters deprecations to the output of `debug:container` command (HeahDude)
 * feature #51888 [WebProfiler] Profiler improvements / extract Font from stylesheet (smnandre)
 * feature #51058 [FrameworkBundle] Add `--exclude` option to the `cache:pool:clear` command (MatTheCat)
 * feature #51845 [AssetMapper] Add outdated command (Maelan LE BORGNE)
 * feature #51976 [Workflow] Revert deprecation about Registry (lyrixx)
 * feature #50537 [Console] Add placeholders to ProgressBar for exact times (maxbeckers)
 * feature #51717 [Notifier] [Telegram] Extend options for `location`, `document`, `audio`, `video`, `venue`, `photo`, `animation`, `sticker` & `contact` (igrizzli)
 * feature #49044 [Messenger] Mention the transport which failed during the setup command (thePanz)
 * feature #51786 [AssetMapper] Always downloading vendor files (weaverryan)
 * feature #51832 [DependencyInjection] Add `#[AutowireIterator]` attribute and improve `#[AutowireLocator]` (nicolas-grekas, kbond)
 * feature #50934 [Form] Add `duplicate_preferred_choices` option to `ChoiceType` (arnaud-deabreu)
 * feature #51650 [AssetMapper] Add audit command (Jean-Beru)
 * feature #51771 Update the design of the Symfony Welcome Page (javiereguiluz)
 * feature #51800 [DoctrineBridge] Pass `Request` to `EntityValueResolver`'s expression (HypeMC)
 * feature #51848 [Messenger] Resend failed retries back to failure transport (ro0NL)
 * feature #51811 Add "dev" keyword to symfony/symfony package (nicolas-grekas)
 * feature #51276 [Notifier] Transport possible to have null (StaffNowa)
 * feature #50662 [FrameworkBundle] Add `HttpClientAssertionsTrait` which provide shortcuts to assert HTTP calls was triggered (welcoMattic)
 * feature #50392 Move UriSigner from HttpKernel to HttpFoundation package (alexander-schranz)
 * feature #51804 [Security] Make `impersonation_path()` argument mandatory and add `impersonation_url()` (alexandre-daubois)
 * feature #50127 [TwigBridge] Add `FormLayoutTestCase` class (ker0x)
 * feature #50030 Add new twig bridge function to generate impersonation path (PhilETaylor)
 * feature #50109 [FrameworkBundle] Add --show-aliases option to debug:router command (fancyweb)
 * feature #50141 Allow sending scheduled messages through the slack API (Insanfly)
 * feature #50321 [TwigBridge] Add `AppVariable::getEnabledLocales()`  (jmsche)
 * feature #51676 [RateLimiter] Add SlidingWindowLimiter::reserve() (Jeroeny)
 * feature #51538 [HttpFoundation] Support root-level Generator in StreamedJsonResponse (Jeroeny)
 * feature #51653 [Messenger] Add WrappedExceptionsInterface for nested exceptions (Jeroeny)
 * feature #51690 [Mime] Add `TemplatedEmail::locale()` to set the locale for the email rendering (alexander-schranz)
 * feature #51525 [Messenger][Scheduler] Add AsCronTask & AsPeriodicTask attributes (valtzu)
 * feature #51795 [Scheduler] Make debug:scheduler output more useful (fabpot)
 * feature #51793 [FrameworkBundle] Change BrowserKitAssertionsTrait::getClient() to be protected (fabpot)
 * feature #44629 [FrameworkBundle] Allow BrowserKit relative URL redirect assert (julienfalque)
 * feature #51756 [Messenger] RejectRedeliveredMessageException should not be retried (nikophil)
 * feature #51779 [Serializer] Make `ProblemNormalizer` give details about Messenger’s `ValidationFailedException` (MatTheCat)
 * feature #51772 [WebProfilerBundle] Support `!` negation operator in url filter (SzymonKaminski)
 * feature #51729 [AssetMapper] Allow simple, relative paths in importmap.php (weaverryan)
 * feature #51697 [PropertyInfo] Make isWriteable() more consistent with isReadable() when checking snake_case properties (jbtronics)
 * feature #51543 [AssetMapper] Add support for CSS files in the importmap (weaverryan)
 * feature #51593 [Messenger] Add the `--all` option to the `messenger:failed:remove` command (alexandre-daubois)
 * feature #51542 [Scheduler] Trigger unique messages at runtime (Jeroeny)
 * feature #51415 [Clock] Add `DatePoint`: an immutable DateTime implementation with stricter error handling and return types (nicolas-grekas)
 * feature #51553 [Scheduler] Allow modifying the schedule at runtime and recalculate heap (Jeroeny)
 * feature #51703 [PhpUnitBridge] Add some more native types (d-eff-it)
 * feature #51712 Deprecate `Kernel::stripComments()` (alamirault)
 * feature #51687 [Messenger] Add support for multiple Redis Sentinel hosts (digilist)
 * feature #51153 [Translation] Add `--as-tree` option  to `translation:pull` command (syffer)
 * feature #51601 [Mime] Allow to add some headers as a strings (Oipnet)
 * feature #51684 [Translation] Give current locale to `LocaleSwitcher::runWithLocale()`'s callback (alexander-schranz)
 * feature #51651 [Scheduler] Fix stateful scheduler (valtzu)
 * feature #51638 [FrameworkBundle] [Test] add token attributes in `KernelBrowser::loginUser()` (Valmonzo)
 * feature #51558 [HttpClient] Enable using EventSourceHttpClient::connect() for both GET and POST (wivaku)
 * feature #51476 [Serializer] Allow Context to target classes (mtarld)
 * feature #50438 [Validator] Add is_valid function to Expression constraint (verdet23, DEVizzent)
 * feature #51626 [TwigBridge][TwigBundle] Drop support for Twig 2 (derrabus)
 * feature #51585 [Security] Add badge resolution to profiler (Jean-Beru)
 * feature #51523 [AssetMapper] Allow specifying packages to update with importmap:update (jmsche)
 * feature #51549 [Workflow] Remove `GuardEvent::getContext()` method without replacement (alexandre-daubois)
 * feature #51493 Remove `GuardEvent::getContext()` method and add `HasContextTrait` trait (hhamon)
 * feature #50705 [Mailer][Webhook] Add Sendgrid webhook support (WoutervanderLoopNL)
 * feature #51450 [Mailer] [Smtp] Add DSN param `peer_fingerprint` for fingerprint verification (xdavidwu)
 * feature #51484 [Workflow] deprecate `GuardEvent::getContext` method (hhamon)
 * feature #51351 [AssetMapper] Add command to download missing downloaded packages (jmsche)
 * feature #51454 [Validator] Un-deprecate passing an annotation reader to AnnotationLoader (derrabus)
 * feature #51434 [Security] [Throttling] Hide username and client ip in logs (Spomky)
 * feature #51425 [FrameworkBundle][Validator] Deprecate annotation occurrences (alexandre-daubois)
 * feature #51392 [DependencyInjection] add `#[AutowireLocator]` attribute (kbond)
 * feature #51365 [Clock] Add $modifier argument to the now() helper (nicolas-grekas)
 * feature #51327 [FrameworkBundle] Add `AbstractController::renderBlock()` and `renderBlockView()` (nicolas-grekas)
 * feature #51357 [FrameworkBundle] Deprecate not setting some options (uid, validation) (Jean-Beru)
 * feature #51325 [FrameworkBundle] Deprecate not setting some options (Jean-Beru)
 * feature #51412 [Clock] Throw `DateMalformedStringException`/`DateInvalidTimeZoneException` when appropriate (nicolas-grekas)
 * feature #51368 [DomCrawler] Added argument `$default` to method `Crawler::attr()` (Rastishka)
 * feature #51315 [Notifier][Webhook] Add Vonage support (smnandre)
 * feature #51349 [Notifier] Add GoIP bridge (ahmedghanem00)
 * feature #51332 [SecurityBundle] Deprecate the `require_previous_session` config option (alamirault)
 * feature #51284 [FrameworkBundle][HttpKernel][MonologBridge] Revisit wiring of debug loggers (nicolas-grekas)
 * feature #50306 [DomCrawler][FrameworkBundle] Add `assertAnySelectorText*` (SVillette)
 * feature #51263 [Scheduler] Add --all to debug:schedule (fabpot)
 * feature #50939 [SecurityBundle] Add `$badges` argument to `Security::login` (MatTheCat)
 * feature #50951 [FrameworkBundle] Support APP_BUILD_DIR (ro0NL)
 * feature #51264 [RemoteEvent][Webhook] Add Brevo support (blaugueux)
 * feature #50502 [RemoteEvent][Webhook] Add Mailjet support (blaugueux)
 * feature #51250 Remove remaining experimental classes (fabpot)
 * feature #51249 [RemoteEvent] Mark component as non experimental (fabpot)
 * feature #51248 [Webhook] Mark component as non experimental (fabpot)
 * feature #51247 [AssetMapper] Mark component as non experimental (fabpot)
 * feature #51246 [Scheduler] Mark component as non experimental (fabpot)
 * feature #51245 [Scheduler] Only use toString if defined for message (fabpot)
 * feature #51244 [Scheduler] Add --date to schedule:debug (fabpot)
 * feature #51210 [Workflow] Add PHP attributes to register listeners and guards (lyrixx)
 * feature #48485 [Process] Introducing a new `PhpSubprocess` handler (Toflar)
 * feature #51215 [FrameworkBundle] Enable `json_decode_detailed_errors` in dev by default (ostrolucky)
 * feature #51004 [HttpKernel] Support backed enums in `#[MapQueryParameter]` (andersmateusz)
 * feature #51230 [Scheduler] add `ScheduledStamp` to `RedispatchMessage` (kbond)
 * feature #51218 [Workflow] Support multiline descriptions in PlantUML (valtzu)
 * feature #51073 [Intl] Add support for ISO 3166-1 numeric codes (benr77)
 * feature #51191 [Mime] Update mimetypes (fabpot)
 * feature #47422 [Process] Support using `Process::findExecutable()` independently of `open_basedir` (BlackbitDevs)
 * feature #48907 [Validator] Validate time without seconds (xepozz)
 * feature #51204 [Workflow] Add a profiler (lyrixx)
 * feature #47715 [Form] Removing self-closing slash from `<input>` (ThomasLandauer)
 * feature #50212 [FrameworkBundle][Serializer] Add TranslatableNormalizer (Jean-Beru)
 * feature #50767 [HttpKernel] RequestPayloadValueResolver Add support for custom http status code (zim32)
 * feature #51172 [Serializer] Add support for seld/jsonlint (ostrolucky)
 * feature #49231 [Translation] Phrase translation provider (wickedOne)
 * feature #50974 [Workflow] Add support for storing the marking in a property (lyrixx)
 * feature #51092 [Scheduler] make `ScheduledStamp` "send-able" (kbond)
 * feature #51197 [PsrHttpMessageBridge] Support `php-http/discovery` for auto-detecting PSR-17 factories (derrabus)
 * feature #48841 [BrowserKit] Add argument $serverParameters to click() and clickLink() (syl20b)
 * feature #49594 [Serializer] Groups annotation/attribute on class (Brajk19)
 * feature #50879 [Notifier] support local development for sns by adding sslmode option (Ferror)
 * feature #51152 [Scheduler] Add `AbstractTriggerDecorator` (kbond)
 * feature #51170 [Templating] Remove the component (fabpot)
 * feature #49814 [Console][Messenger] add `RunCommandMessage` and `RunCommandMessageHandler` (kbond)
 * feature #50978 [Messenger] Allow accessing all options on a handler descriptor (ruudk)
 * feature #50911 [HttpKernel] Enhance exception if possible (lyrixx)
 * feature #50136 [Notifier] [SpotHit] Support `smslong` and `smslongnbr` API parameters (camillebaronnet)
 * feature #50907 [Validator] Update `Type` constraint, add `number`, `finite-float` and `finite-number` validations (guillaume-a)
 * feature #51130 [VarDumper] Dump uninitialized properties (nicolas-grekas)
 * feature #51144 [Templating] deprecate the component (kbond)
 * feature #51014 [Mailer] Add Scaleway bridge (MrMicky-FR)
 * feature #51167 [PsrHttpMessageBridge] Remove ArgumentValueResolverInterface from PsrServerRequestResolver (derrabus)
 * feature #51100 [PsrHttpMessageBridge] Import the bridge into the monorepo (fabpot, dunglas, KorvinSzanto, xabbuh, aimeos, ahundiak, Danielss89, rougin, csunolgomez, Jérôme Parmentier, mtibben, Nyholm, ajgarlag, uphlewis, samnela, grachevko, nicolas-grekas, tinyroy, danizord, Daniel Degasperi, rbaarsma, Ekman, 4rthem, derrabus, mleczakm, iluuu1994, Tobion, chalasr, lemon-juice, franmomu, cidosx, erikn69, AurelienPillevesse)
 * feature #49815 [HttpClient][Messenger] add `PingWebhookMessage` and `PingWebhookMessageHandler` (kbond)
 * feature #49813 [Messenger][Process] add `RunProcessMessage` and `RunProcessMessageHandler` (kbond)
 * feature #51148 [FrameworkBundle] Simplify marking store configuration (nicolas-grekas)
 * feature #51128 [SecurityBundle] Allow an array of `pattern` in firewall configuration (lyrixx, chalasr)
 * feature #51091 [MonologBridge] Remove support for monolog < 3.0 (lyrixx)
 * feature #51069 Add types to public and protected properties (nicolas-grekas)
 * feature #51076 [Form] Remove deprecations in form events (HeahDude)
 * feature #51082 [Routing] Remove Doctrine annotations support (derrabus)
 * feature #119 Implement ValueResolverInterface (derrabus)
 * feature #117 Leverage `Request::getPayload()` to populate the parsed body of PSR-7 requests (AurelienPillevesse)
 * feature #50931 [Form] Support Translatable Enum (Seb33300)
 * feature #51085 [Validator] Remove Doctrine annotations support (derrabus)
 * feature #51080 [Serializer] Remove Doctrine annotations support (derrabus)
 * feature #49358 [Routing] Deprecate annotations in favor of attributes (derrabus)
 * feature #50982 [Validator] Deprecate annotations in favor of attributes (derrabus)
 * feature #50983 [Serializer] Deprecate annotations in favor of attributes (derrabus)
 * feature #51050 [FrameworkBundle] Remove doctrine/annotations integration (derrabus)
 * feature #51043 [Form] Deprecate `FormEvent::setData()` for events that do not allow it (HeahDude)
 * feature #50888 [FrameworkBundle] Deprecate doctrine/annotations integration (derrabus)
 * feature #50997 [Messenger] Deprecate `StopWorkerOnSignalsListener` (HypeMC)
 * feature #50290 [Security] Make `PersistentToken` immutable and tell `TokenProviderInterface::updateToken()` implementations should accept `DateTimeInterface` (nicolas-grekas)
 * feature #50883 [TwigBundle] Allow omitting the `autoescape_service_method` option when `autoescape_service` is set to an invokable service id (nicolas-grekas)
 * feature #50718 [DependencyInjection] Improve reporting named autowiring aliases (nicolas-grekas)
 * feature #50295 [PropertyAccess] Auto-cast from/to DateTime/Immutable when appropriate (nicolas-grekas)
 * feature #50420 [Console] add support for catching `\Throwable` errors (lyrixx)
 * feature #50807 [HttpClient] Add an HAR response factory for testing (GaryPEGEOT)
 * feature #50917 [Notifier] Remove the Sendinblue bridge (fabpot)
 * feature #50916 [Mailer] Remove the Sendinblue bridge (fabpot)
 * feature #50148 [Mailer] Add X-Infobip-Track header to be able to disable tracking (ndousson)
 * feature #50200 [Mailer] Adds `assertEmailSubjectContains` and `assertEmailSubjectNotContains` methods (johanadivare)
 * feature #50302 [Mailer] New Brevo mailer bridge (formerly Sendinblue) (PEtanguy)
 * feature #50296 [Notifier] Add Brevo bridge (formerly Sendinblue) (PEtanguy)
 * feature #50852 [Components] Convert to native return types (wouterj)
 * feature #50842 Add missing return types to magic methods (wouterj)
 * feature #50873  Remove remaining deprecated code paths (nicolas-grekas)
 * feature #50880 [Lock] 7.0 remove deprecations in Lock Component (fafiebig)
 * feature #50869 [Mime] remove deprecated methods in Mime Component (fafiebig)
 * feature #50858 [HttpKernel] Remove deprecated code paths (nicolas-grekas)
 * feature #50867 [ExpressionLanguage] Remove deprecated code paths (alexandre-daubois)
 * feature #50866 [Security] Remove deprecated code paths (nicolas-grekas)
 * feature #50857 [Validator] Remove deprecated code paths (nicolas-grekas)
 * feature #50862 [HttpClient] Remove implementing `Http\Message\RequestFactory` from `HttplugClient` (nicolas-grekas)
 * feature #50868 [SecurityBundle] Deprecate `Security::*` consts and other cleanups (nicolas-grekas)
 * feature #50839 Remove BC layers related to new methods and new parameters (nicolas-grekas)
 * feature #50846 [Bridges][Bundles] Convert to native return types (wouterj)
 * feature #50770 [TwigBridge] Allow to change element for `form_help` block (seb-jean)
 * feature #50826 [HttpFoundation] Remove deprecated classes, method and behaviors (GromNaN)
 * feature #50578 [DependencyInjection] Remove deprecations across the component (alexandre-daubois)
 * feature #50613 [Console] Remove deprecations across the component (alexandre-daubois)
 * feature #50736 [Serializer] Remove BC layer (lyrixx)
 * feature #50814 [HttpClient] Allow custom working directory in TestHttpServer (ro0NL)
 * feature #46426 [Form] deprecate using the date and time types with date objects with not-matching timezones (xabbuh)
 * feature #50689 [Cache][DoctrineBridge][Lock][Messenger] Add parameter $isSameDatabase to configureSchema() methods (alli83)
 * feature #50791 [DependencyInjection] Add `defined` prefix for env var processor (GaryPEGEOT)
 * feature #50754 [HttpKernel] when configuring the container add services_{env} with php extension  (helyakin)
 * feature #50425 [Validator] Allow single constraint to be passed to the `constraints` option of the `When` constraint (alexandre-daubois)
 * feature #50396 [Validator] Allow single integer for the `versions` option of the `Uuid` constraint (alexandre-daubois)
 * feature #50621 [FrameworkBundle][Workflow] Add metadata dumping support for `GraphvizDumper` (Louis-Proffit)
 * feature #50170 [Notifier] Added redlink notifier (plotkabytes)
 * feature #50615 [DependencyInjection] Deprecate `ContainerAwareInterface`, `ContainerAwareTrait` and `ContainerAwareLoader` (alexandre-daubois)
 * feature #50084 [Routing] Add FQCN and FQCN::method aliases when applicable (fancyweb)
 * feature #50691 [Console] Aligned multiline text in vertical table (jaytaph)
 * feature #50131 [Notifier] add Ntfy bridge (mikaelkael)
 * feature #50663 [Console] Add `SignalMap` to map signal value to its name (lyrixx)
 * feature #50414 [Notifier] Add Novu bridge (wouter-toppy)
 * feature #50571 [DoctrineBridge] Kill DBAL 2 support (derrabus)
 * feature #50240 [HttpClient] Add `max_retries` option to `RetryableHttpClient` (danielburger1337)
 * feature #50575 [DoctrineBridge] Remove deprecated classes and `ContainerAwareEventManager::getListeners()` deprecation (alexandre-daubois)
 * feature #50600 [ProxyManagerBridge] Drop the bridge (nicolas-grekas)
 * feature #50572 [Scheduler] Allow setting cron expression next run date timezone (danielburger1337)
 * feature #50573 [SecurityBundle] Enabling `SecurityBundle` and not configuring it is not allowed (alexandre-daubois)
 * feature #50579 [DoctrineBridge] Deprecate using the old DBAL logger system (derrabus)
 * feature #50558 [Serializer] Remove abstract uid denormalization code (fancyweb)
 * feature #50335 [HttpKernel] Add optional `$className` param to `ControllerEvent::getAttributes()` (HypeMC)
 * feature #50404  Bump to PHP 8.2 minimum (nicolas-grekas)
 * feature #113 Bump psr/http-message version (erikn69)
 * feature #114 Drop support for Symfony 4 (derrabus)
 * feature #100 Allow Symfony 6 (chalasr)
 * feature #89 PSR HTTP message converters for controllers (derrabus)
 * feature #75 Remove deprecated code (fabpot)
 * feature #66 Add support for streamed Symfony request (Ekman)
 * feature #50 Add support for streamed response (danizord)
 * feature #62 bump to PHP 7.1 (nicolas-grekas)
 * feature #43 Create PSR-7 messages using PSR-17 factories (ajgarlag)
 * feature #45 Fixed broken build (Nyholm)
 * feature #1 Initial support (dunglas)
